/*
 * Decompiled with CFR 0.152.
 */
package simplexml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objenesis.ObjenesisHelper;
import simplexml.model.Element;
import simplexml.model.EventParser;
import simplexml.model.ObjectDeserializer;
import simplexml.model.XmlAbstractClass;
import simplexml.utils.Interfaces;
import simplexml.utils.Reflection;
import simplexml.utils.XML;

public interface XmlReader
extends Interfaces.AccessDeserializers {
    default public <T> T domToObject(Element node, Class<T> clazz) throws IllegalAccessException {
        if (node == null) {
            return null;
        }
        ObjectDeserializer c = this.getDeserializer(clazz);
        if (c != null) {
            return c.convert(node, clazz);
        }
        Object o = ObjenesisHelper.newInstance(clazz);
        block8: for (Field f : Reflection.listFields(clazz)) {
            f.setAccessible(true);
            if (Modifier.isStatic(f.getModifiers())) continue;
            switch (Reflection.toFieldType(f)) {
                case TEXTNODE: {
                    f.set(o, this.textNodeToValue(f.getType(), node));
                    continue block8;
                }
                case ANNOTATED_ATTRIBUTE: {
                    f.set(o, this.attributeToValue(f.getType(), Reflection.toName(f), this.deWrap(node, f)));
                    continue block8;
                }
                case SET: {
                    f.set(o, this.domToSet(Reflection.toClassOfCollection(f), Reflection.toName(f), this.deWrap(node, f)));
                    continue block8;
                }
                case LIST: {
                    f.set(o, this.domToList(Reflection.toClassOfCollection(f), Reflection.toName(f), this.deWrap(node, f)));
                    continue block8;
                }
                case ARRAY: {
                    f.set(o, this.domToArray(f.getType().getComponentType(), Reflection.toName(f), this.deWrap(node, f)));
                    continue block8;
                }
                case MAP: {
                    f.set(o, this.domToMap((ParameterizedType)f.getGenericType(), Reflection.toName(f), this.deWrap(node, f)));
                    continue block8;
                }
            }
            String name = Reflection.toName(f);
            String value = node.attributes.get(name);
            if (value != null) {
                f.set(o, this.stringToValue(f.getType(), value));
                continue;
            }
            if (Reflection.isAbstract(f)) {
                Element child = node.findChildForName(name, null);
                f.set(o, this.domToObject(child, Reflection.findAbstractType(f.getAnnotation(XmlAbstractClass.class), child)));
                continue;
            }
            f.set(o, this.domToObject(this.deWrap(node, f).findChildForName(name, null), f.getType()));
        }
        return (T)o;
    }

    default public Element deWrap(Element element, Field field) {
        if (!Reflection.isWrapped(field)) {
            return element;
        }
        return element.findChildForName(Reflection.toWrappedName(field), null);
    }

    default public Object textNodeToValue(Class<?> type, Element node) throws IllegalAccessException {
        ObjectDeserializer conv = this.getDeserializer(type);
        return conv != null ? conv.convert(node) : null;
    }

    default public Object attributeToValue(Class<?> type, String name, Element node) throws IllegalAccessException {
        ObjectDeserializer conv = this.getDeserializer(type);
        if (conv == null) {
            return null;
        }
        String value = node.attributes.get(name);
        if (value == null) {
            return null;
        }
        return conv.convert(value);
    }

    default public Object stringToValue(Class<?> type, String value) {
        ObjectDeserializer conv = this.getDeserializer(type);
        return conv != null ? conv.convert(value) : null;
    }

    default public Set<Object> domToSet(Class<?> type, String name, Element node) throws IllegalAccessException {
        ObjectDeserializer elementConv = this.getDeserializer(type);
        HashSet<Object> set = new HashSet<Object>();
        for (Element n : node.children) {
            if (!n.name.equals(name)) continue;
            set.add(elementConv == null ? this.domToObject(n, type) : elementConv.convert(n));
        }
        return set;
    }

    default public List<Object> domToList(Class<?> type, String name, Element node) throws IllegalAccessException {
        ObjectDeserializer elementConv = this.getDeserializer(type);
        LinkedList<Object> list = new LinkedList<Object>();
        for (Element n : node.children) {
            if (!n.name.equals(name)) continue;
            list.add(elementConv == null ? this.domToObject(n, type) : elementConv.convert(n));
        }
        return list;
    }

    default public Object[] domToArray(Class<?> type, String name, Element node) throws IllegalAccessException {
        ObjectDeserializer elementConv = this.getDeserializer(type);
        Object[] array = (Object[])Array.newInstance(type, node.numChildrenWithName(name));
        int i = 0;
        for (Element n : node.children) {
            if (!n.name.equals(name)) continue;
            array[i] = elementConv == null ? this.domToObject(n, type) : elementConv.convert(n, type);
            ++i;
        }
        return array;
    }

    default public Map<Object, Object> domToMap(ParameterizedType type, String name, Element node) throws IllegalAccessException {
        Element element = node.findChildForName(name, null);
        if (element == null) {
            return null;
        }
        ObjectDeserializer convKey = this.getDeserializer(Reflection.toClassOfMapKey(type));
        ObjectDeserializer convVal = this.getDeserializer(Reflection.toClassOfMapValue(type));
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Element child : element.children) {
            map.put(convKey.convert(child.name), convVal.convert(child));
        }
        return map;
    }

    public static Element parseXML(InputStreamReader in) throws IOException {
        String str;
        EventParser p = new EventParser();
        while ((str = XmlReader.readLine(in, '<')) != null) {
            if (!str.isEmpty()) {
                p.someText(XML.unescapeXml(str.trim()));
            }
            if ((str = XmlReader.readLine(in, '>').trim()).charAt(0) == '?') continue;
            if (str.charAt(0) == '/') {
                p.endNode();
                continue;
            }
            String name = XmlReader.getNameOfTag(str);
            if (str.length() == name.length()) {
                p.startNode(str, new HashMap<String, String>());
                continue;
            }
            int beginAttr = name.length();
            int end = str.length();
            if (str.endsWith("/")) {
                p.startNode(name, XmlReader.parseAttributes(str.substring(beginAttr, end - 1)));
                p.endNode();
                continue;
            }
            p.startNode(name, XmlReader.parseAttributes(str.substring(beginAttr + 1, end)));
        }
        return p.getRoot();
    }

    public static String readLine(InputStreamReader in, char end) throws IOException {
        int data;
        LinkedList<Character> chars = new LinkedList<Character>();
        while ((data = in.read()) != -1 && data != end) {
            chars.add(Character.valueOf((char)data));
        }
        if (data == -1) {
            return null;
        }
        char[] value = new char[chars.size()];
        int i = 0;
        for (Character c : chars) {
            value[i++] = c.charValue();
        }
        return new String(value);
    }

    public static String getNameOfTag(String tag) {
        int offset;
        for (offset = 0; offset < tag.length() && tag.charAt(offset) != ' ' && tag.charAt(offset) != '/'; ++offset) {
        }
        return tag.substring(0, offset);
    }

    public static HashMap<String, String> parseAttributes(String input) {
        int equals;
        int startName;
        HashMap<String, String> attributes = new HashMap<String, String>();
        while (!input.isEmpty() && (startName = XmlReader.indexOfNonWhitespaceChar(input, 0)) != -1 && (equals = input.indexOf(61, startName + 1)) != -1) {
            String value;
            int endValue;
            String name = input.substring(startName, equals).trim();
            int startValue = XmlReader.indexOfNonWhitespaceChar(input = input.substring(equals + 1), 0);
            if (startValue == -1) break;
            if (input.charAt(startValue) == '\"') {
                if ((endValue = input.indexOf(34, ++startValue)) == -1) {
                    endValue = input.length() - 1;
                }
                value = input.substring(startValue, endValue).trim();
            } else {
                endValue = XmlReader.indexOfWhitespaceChar(input, startValue + 1);
                if (endValue == -1) {
                    endValue = input.length() - 1;
                }
                value = input.substring(startValue, endValue + 1).trim();
            }
            input = input.substring(endValue + 1);
            attributes.put(name, XML.unescapeXml(value));
        }
        return attributes;
    }

    public static int indexOfNonWhitespaceChar(String input, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            char at = input.charAt(i);
            if (at == ' ' || at == '\t' || at == '\n' || at == '\r') continue;
            return i;
        }
        return -1;
    }

    public static int indexOfWhitespaceChar(String input, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            char at = input.charAt(i);
            if (at != ' ' && at != '\t' && at != '\n' && at != '\r') continue;
            return i;
        }
        return -1;
    }
}

