/*
 * Decompiled with CFR 0.152.
 */
package simplexml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import simplexml.XmlReader;
import simplexml.model.Element;
import simplexml.model.InvalidXml;
import simplexml.utils.Interfaces;

public interface XmlStream {
    default public Interfaces.CheckedIterator<String> iterateXml(final InputStreamReader in) {
        return new Interfaces.CheckedIterator<String>(){

            @Override
            public boolean hasNext() throws IOException {
                Character next = XmlStream.readFirstNonWhiteChar(in);
                if (next == null) {
                    return false;
                }
                if (next.charValue() == '<') {
                    return true;
                }
                throw new InvalidXml();
            }

            @Override
            public String next() throws IOException {
                return XmlStream.readUntilCurrentTagIsClosed(in);
            }
        };
    }

    default public Interfaces.CheckedIterator<Element> iterateDom(final InputStreamReader in, final Charset charset) {
        return new Interfaces.CheckedIterator<Element>(){

            @Override
            public boolean hasNext() throws Exception {
                Character next = XmlStream.readFirstNonWhiteChar(in);
                if (next == null) {
                    return false;
                }
                if (next.charValue() == '<') {
                    return true;
                }
                throw new InvalidXml();
            }

            @Override
            public Element next() throws Exception {
                String xml = XmlStream.readUntilCurrentTagIsClosed(in);
                return XmlReader.parseXML(new InputStreamReader((InputStream)new ByteArrayInputStream(xml.getBytes(charset)), charset));
            }
        };
    }

    default public <T> Interfaces.CheckedIterator<T> iterateObject(final InputStreamReader in, final Charset charset, final XmlReader reader, final Class<T> clazz) {
        return new Interfaces.CheckedIterator<T>(){

            @Override
            public boolean hasNext() throws Exception {
                Character next = XmlStream.readFirstNonWhiteChar(in);
                if (next == null) {
                    return false;
                }
                if (next.charValue() == '<') {
                    return true;
                }
                throw new InvalidXml();
            }

            @Override
            public T next() throws Exception {
                String xml = XmlStream.readUntilCurrentTagIsClosed(in);
                Element element = XmlReader.parseXML(new InputStreamReader((InputStream)new ByteArrayInputStream(xml.getBytes(charset)), charset));
                return reader.domToObject(element, clazz);
            }
        };
    }

    public static Character readFirstNonWhiteChar(InputStreamReader in) throws IOException {
        int r;
        while ((r = in.read()) != -1) {
            char c = (char)r;
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return Character.valueOf(c);
        }
        return null;
    }

    public static String readUntilCurrentTagIsClosed(InputStreamReader in) throws IOException {
        int r;
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        boolean previousWasForwardSlash = false;
        boolean previousWasSmallerThan = true;
        int numberOfTagsOpened = 1;
        block0: while ((r = in.read()) != -1) {
            char c = (char)r;
            builder.append(c);
            if (c == '>' && previousWasForwardSlash) {
                --numberOfTagsOpened;
            }
            if (c == '/' && previousWasSmallerThan) {
                numberOfTagsOpened -= 2;
            }
            if (c == '<') {
                ++numberOfTagsOpened;
            }
            if (numberOfTagsOpened < 0) {
                throw new InvalidXml();
            }
            if (numberOfTagsOpened == 0) {
                if (c == '>') break;
                while ((r = in.read()) != -1) {
                    char ch = (char)r;
                    builder.append(ch);
                    if (ch != '>') continue;
                    break block0;
                }
                break;
            }
            previousWasForwardSlash = c == '/';
            previousWasSmallerThan = c == '<';
        }
        return builder.toString();
    }
}

