/*
 * Decompiled with CFR 0.152.
 */
package simplexml.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import simplexml.model.Element;
import simplexml.model.XmlAbstractClass;
import simplexml.model.XmlAttribute;
import simplexml.model.XmlName;
import simplexml.model.XmlNoExport;
import simplexml.model.XmlTextNode;
import simplexml.model.XmlWrapperTag;
import simplexml.utils.Interfaces;

public enum Reflection {

    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_OBJECT = Reflection.primitiveToObject();

    public static Field determineTypeOfFields(Class<?> clazz, Object o, List<Field> attributes, List<Field> childNodes) throws IllegalAccessException {
        Field textNode = null;
        for (Field f : clazz.getDeclaredFields()) {
            f.setAccessible(true);
            if (f.get(o) == null || Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || f.isAnnotationPresent(XmlNoExport.class)) continue;
            if (f.isAnnotationPresent(XmlTextNode.class)) {
                textNode = f;
                continue;
            }
            if (f.isAnnotationPresent(XmlAttribute.class)) {
                attributes.add(f);
                continue;
            }
            childNodes.add(f);
        }
        return textNode;
    }

    public static FieldType toFieldType(Field f) {
        if (f.isAnnotationPresent(XmlTextNode.class)) {
            return FieldType.TEXTNODE;
        }
        if (f.isAnnotationPresent(XmlAttribute.class)) {
            return FieldType.ANNOTATED_ATTRIBUTE;
        }
        Class<?> type = f.getType();
        if (Set.class.isAssignableFrom(type)) {
            return FieldType.SET;
        }
        if (List.class.isAssignableFrom(type)) {
            return FieldType.LIST;
        }
        if (type.isArray()) {
            return FieldType.ARRAY;
        }
        if (Map.class.isAssignableFrom(type)) {
            return FieldType.MAP;
        }
        return FieldType.OTHER;
    }

    public static ClassType toClassType(Class<?> c, Interfaces.AccessSerializers s) {
        if (Reflection.isSimple(c) || s.hasSerializer(c)) {
            return ClassType.SIMPLE;
        }
        if (c.isArray()) {
            return ClassType.ARRAY;
        }
        if (Reflection.isList(c)) {
            return ClassType.LIST;
        }
        if (Reflection.isSet(c)) {
            return ClassType.SET;
        }
        if (Reflection.isMap(c)) {
            return ClassType.MAP;
        }
        return ClassType.OBJECT;
    }

    public static List<Field> listFields(Class<?> type) {
        return Reflection.listFields(new ArrayList<Field>(), type);
    }

    public static List<Field> listFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            Reflection.listFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static boolean isSimple(Class<?> c) {
        return c.isAssignableFrom(Double.class) || c.isAssignableFrom(Double.TYPE) || c.isAssignableFrom(Integer.class) || c.isAssignableFrom(String.class) || c.isAssignableFrom(Integer.TYPE) || c.isAssignableFrom(Float.TYPE) || c.isAssignableFrom(Float.class) || c.isAssignableFrom(Byte.TYPE) || c.isAssignableFrom(Byte.class) || c.isAssignableFrom(Character.TYPE) || c.isAssignableFrom(Character.class) || c.isAssignableFrom(Short.TYPE) || c.isAssignableFrom(Short.class) || c.isAssignableFrom(Long.class) || c.isAssignableFrom(Long.TYPE) || c.isAssignableFrom(Boolean.TYPE) || c.isAssignableFrom(Boolean.class);
    }

    public static boolean isList(Class<?> c) {
        return c.isAssignableFrom(List.class);
    }

    public static boolean isSet(Class<?> c) {
        return c.isAssignableFrom(Set.class);
    }

    public static boolean isMap(Class<?> c) {
        return c.isAssignableFrom(Map.class);
    }

    public static boolean isWrapped(Field f) {
        return f.isAnnotationPresent(XmlWrapperTag.class);
    }

    public static String toWrappedName(Field f) {
        return f.getAnnotation(XmlWrapperTag.class).value();
    }

    public static boolean isAbstract(Field f) {
        return f.isAnnotationPresent(XmlAbstractClass.class);
    }

    public static Class<?> findAbstractType(XmlAbstractClass annotation, Element node) throws IllegalAccessException {
        String typeName = node.attributes.get(annotation.attribute());
        for (XmlAbstractClass.TypeMap map : annotation.types()) {
            if (!typeName.equals(map.name())) continue;
            return map.type();
        }
        throw new IllegalAccessException(String.format("Missing type for '%s'", typeName));
    }

    public static String toName(Class<?> o) {
        if (!o.isAnnotationPresent(XmlName.class)) {
            return o.getSimpleName().toLowerCase();
        }
        return o.getAnnotation(XmlName.class).value();
    }

    public static String toName(Field field) {
        if (field.isAnnotationPresent(XmlName.class)) {
            return field.getAnnotation(XmlName.class).value();
        }
        return field.getName();
    }

    public static Class<?> toClassOfCollection(Field f) {
        ParameterizedType stringListType = (ParameterizedType)f.getGenericType();
        return (Class)stringListType.getActualTypeArguments()[0];
    }

    public static Class<?> toClassOfMapKey(ParameterizedType type) {
        return (Class)type.getActualTypeArguments()[0];
    }

    public static Class<?> toClassOfMapValue(ParameterizedType type) {
        return (Class)type.getActualTypeArguments()[1];
    }

    private static Map<Class<?>, Class<?>> primitiveToObject() {
        HashMap classes = new HashMap();
        classes.put(Boolean.TYPE, Boolean.class);
        classes.put(Byte.TYPE, Byte.class);
        classes.put(Character.TYPE, Character.class);
        classes.put(Double.TYPE, Double.class);
        classes.put(Float.TYPE, Float.class);
        classes.put(Integer.TYPE, Integer.class);
        classes.put(Long.TYPE, Long.class);
        classes.put(Short.TYPE, Short.class);
        classes.put(Void.TYPE, Void.class);
        return classes;
    }

    public static <T> Class<T> toObjectClass(Class<T> clazz) {
        return clazz.isPrimitive() ? PRIMITIVE_TO_OBJECT.get(clazz) : clazz;
    }

    public static enum ClassType {
        SIMPLE,
        ARRAY,
        LIST,
        SET,
        MAP,
        OBJECT;

    }

    public static enum FieldType {
        TEXTNODE,
        ANNOTATED_ATTRIBUTE,
        SET,
        LIST,
        ARRAY,
        MAP,
        OTHER;

    }
}

