/*
 * Decompiled with CFR 0.152.
 */
package simplexml.utils;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import simplexml.utils.Functions;
import simplexml.utils.Reflection;

public enum XML {


    public static String escapeXml(String str, boolean encodeUTF8) {
        if (Functions.isNullOrEmpty(str)) {
            return str;
        }
        StringBuilder encoded = new StringBuilder();
        block7: for (char c : str.toCharArray()) {
            switch (c) {
                case '<': {
                    encoded.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    encoded.append("&quot;");
                    continue block7;
                }
                case '>': {
                    encoded.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    encoded.append("&apos;");
                    continue block7;
                }
                case '&': {
                    encoded.append("&amp;");
                    continue block7;
                }
                default: {
                    encoded.append(encodeUTF8 && c > '~' ? "&#" + c + ";" : Character.valueOf(c));
                }
            }
        }
        return encoded.toString();
    }

    public static String unescapeXml(String text) {
        StringBuilder result = new StringBuilder(text.length());
        int i = 0;
        int n = text.length();
        while (i < n) {
            char charAt = text.charAt(i);
            if (charAt != '&') {
                result.append(charAt);
                ++i;
                continue;
            }
            if (text.startsWith("&amp;", i)) {
                result.append('&');
                i += 5;
                continue;
            }
            if (text.startsWith("&apos;", i)) {
                result.append('\'');
                i += 6;
                continue;
            }
            if (text.startsWith("&quot;", i)) {
                result.append('\"');
                i += 6;
                continue;
            }
            if (text.startsWith("&lt;", i)) {
                result.append('<');
                i += 4;
                continue;
            }
            if (text.startsWith("&gt;", i)) {
                result.append('>');
                i += 4;
                continue;
            }
            if (text.startsWith("&#", i)) {
                int index = text.indexOf(59, i);
                result.append(XML.toChar(text.substring(i + 2, index)));
                i = index + 1;
                continue;
            }
            ++i;
        }
        return result.toString();
    }

    private static char toChar(String substring) {
        return (char)Integer.parseInt(substring);
    }

    public static String attributesToXml(List<Field> fields, Object o, boolean shouldEncodeUTF8) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder attr = new StringBuilder(6 * fields.size());
        for (Field f : fields) {
            XML.addAttribute(attr, Reflection.toName(f), XML.escapeXml(f.get(o).toString(), shouldEncodeUTF8));
        }
        return attr.toString();
    }

    public static String attributesToXml(Map<String, String> map, boolean shouldEncodeUTF8) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            XML.addAttribute(builder, entry.getKey(), XML.escapeXml(entry.getValue(), shouldEncodeUTF8));
        }
        return builder.toString();
    }

    public static void addAttribute(StringBuilder builder, String name, String value) {
        builder.append(" ").append(name).append("=").append("\"").append(value).append("\"");
    }

    public static void writeTag(Writer writer, String name, String text) throws IOException {
        if (Functions.isNullOrEmpty(text)) {
            XML.writeSelfClosingTag(writer, name);
        } else {
            XML.writeOpeningAndClosingTag(writer, name, text);
        }
    }

    public static void writeTag(Writer writer, String name, String attributes, String text) throws IOException {
        if (Functions.isNullOrEmpty(text)) {
            XML.writeSelfClosingTag(writer, name, attributes);
        } else {
            XML.writeOpeningTag(writer, name, attributes);
            writer.append(text);
            XML.writeClosingTag(writer, name);
        }
    }

    public static void writeOpeningAndClosingTag(Writer writer, String name, String text) throws IOException {
        XML.writeOpeningTag(writer, name);
        writer.append(text);
        XML.writeClosingTag(writer, name);
    }

    public static void writeOpeningTag(Writer writer, String name) throws IOException {
        writer.append("<").append(name).append(">");
    }

    public static void writeOpeningTag(Writer writer, String name, String attributes) throws IOException {
        writer.append("<").append(name).append(attributes).append(">");
    }

    public static void writeClosingTag(Writer writer, String name) throws IOException {
        writer.append("<").append("/").append(name).append(">");
    }

    public static void writeSelfClosingTag(Writer writer, String name) throws IOException {
        writer.append("<").append(name).append("/").append(">");
    }

    public static void writeSelfClosingTag(Writer writer, String name, String attributes) throws IOException {
        writer.append("<").append(name).append(attributes).append(" ").append("/").append(">");
    }
}

