/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.database.ForeignKey;
import com.github.collinalpert.java2db.database.ForeignKeyObject;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.services.BaseService;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BaseMapper<T extends BaseEntity> {
    private Class<T> clazz;

    public BaseMapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Optional<T> map(ResultSet set) {
        BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
        try {
            if (!set.next()) {
                set.close();
                return Optional.empty();
            }
            this.setFields(set, entity);
            set.close();
            return Optional.of(entity);
        }
        catch (IllegalAccessException | SQLException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public List<T> mapToList(ResultSet set) {
        ArrayList<BaseEntity> list = new ArrayList<BaseEntity>();
        try {
            while (set.next()) {
                BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
                this.setFields(set, entity);
                list.add(entity);
            }
            set.close();
        }
        catch (IllegalAccessException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void setFields(ResultSet set, T entity) throws IllegalAccessException {
        ArrayList<Field> fields = Utilities.getAllFields(entity, true);
        try {
            Map<Integer, Integer> foreignKeys = this.getForeignKeys(fields, set);
            Map<Class<?>, Integer> foreignKeyObjects = this.getForeignKeyObjects(fields);
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.getAnnotation(ForeignKeyObject.class) != null) {
                    ForeignKeyObject fkObjectNumber = field.getAnnotation(ForeignKeyObject.class);
                    Class clz = foreignKeyObjects.keySet().stream().filter(x -> x == field.getType()).findFirst().orElseThrow();
                    Object service = IoC.resolveServiceByEntity(clz);
                    Optional fkObject = ((BaseService)service).getById(foreignKeys.get(fkObjectNumber.value()).intValue());
                    if (fkObject.isPresent()) {
                        field.set(entity, fkObject.get());
                        continue;
                    }
                    System.err.printf("Could not set type %s with name %s\n", field.getType(), field.getName());
                    continue;
                }
                Object value = set.getObject(field.getName(), field.getType());
                field.set(entity, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Cannot use base mapping. Please define custom mapping in according mapping class.");
        }
    }

    private Map<Integer, Integer> getForeignKeys(ArrayList<Field> fields, ResultSet set) throws SQLException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Field field : fields) {
            ForeignKey key = field.getAnnotation(ForeignKey.class);
            if (key == null) continue;
            map.put(key.value(), set.getInt(field.getName()));
        }
        return map;
    }

    private Map<Class<?>, Integer> getForeignKeyObjects(ArrayList<Field> fields) {
        return fields.stream().filter(field -> field.getAnnotation(ForeignKeyObject.class) != null).collect(Collectors.toMap(Field::getType, field -> field.getAnnotation(ForeignKeyObject.class).value()));
    }
}

