/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionClassCracker;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.Interpreter;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;

public final class LambdaExpression<F>
extends InvocableExpression {
    private final Expression body;

    LambdaExpression(Class<?> resultType, @NonNull Expression body, List<ParameterExpression> params) {
        super(16, resultType, params);
        if (body == null) {
            throw new NullPointerException("body is marked @NonNull but is null");
        }
        this.body = body;
    }

    public static <T> LambdaExpression<T> parse(T lambda) {
        LambdaExpression<?> lambdaE = ExpressionClassCracker.get().lambda(lambda);
        return lambdaE;
    }

    public Function<Object[], ?> compile() {
        Function f = (Function)this.accept(Interpreter.Instance);
        return f;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        List<ParameterExpression> arguments = this.getParameters();
        if (arguments.size() > 0) {
            b.append('(');
            for (int i = 0; i < arguments.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                    b.append(' ');
                }
                ParameterExpression pe = arguments.get(i);
                b.append(pe.getResultType().getName());
                b.append(' ');
                b.append(pe.toString());
            }
            b.append(')');
        }
        b.append(" -> ");
        b.append(this.getBody().toString());
        b.append('}');
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression other = (LambdaExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$body = this.getBody();
        Expression other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LambdaExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    public Expression getBody() {
        return this.body;
    }
}

