/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.lambda2sql;

import com.github.collinalpert.lambda2sql.LinkedListStack;
import com.github.collinalpert.lambda2sql.functions.TriFunction;
import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.DelegateExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionType;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.lang.reflect.Member;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class SqlVisitor
implements ExpressionVisitor<StringBuilder> {
    private static final Map<Member, Integer> registeredMethods = new HashMap<Member, Integer>(){
        {
            try {
                this.put(String.class.getDeclaredMethod("equals", Object.class), 10);
                this.put(Object.class.getDeclaredMethod("equals", Object.class), 10);
                this.put(LocalDate.class.getDeclaredMethod("isAfter", ChronoLocalDate.class), 12);
                this.put(LocalTime.class.getDeclaredMethod("isAfter", LocalTime.class), 12);
                this.put(LocalDateTime.class.getDeclaredMethod("isAfter", ChronoLocalDateTime.class), 12);
                this.put(LocalDate.class.getDeclaredMethod("isBefore", ChronoLocalDate.class), 20);
                this.put(LocalTime.class.getDeclaredMethod("isBefore", LocalTime.class), 20);
                this.put(LocalDateTime.class.getDeclaredMethod("isBefore", ChronoLocalDateTime.class), 20);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    };
    private final String prefix;
    private final LinkedListStack<List<ConstantExpression>> arguments;
    private final Map<Member, TriFunction<Expression, Expression, Boolean, StringBuilder>> complexMethods = new HashMap<Member, TriFunction<Expression, Expression, Boolean, StringBuilder>>(){
        {
            try {
                this.put(String.class.getDeclaredMethod("startsWith", String.class), (x$0, x$1, x$2) -> SqlVisitor.this.stringStartsWith(x$0, x$1, x$2));
                this.put(String.class.getDeclaredMethod("endsWith", String.class), (x$0, x$1, x$2) -> SqlVisitor.this.stringEndsWith(x$0, x$1, x$2));
                this.put(String.class.getDeclaredMethod("contains", CharSequence.class), (x$0, x$1, x$2) -> SqlVisitor.this.stringContains(x$0, x$1, x$2));
                this.put(List.class.getDeclaredMethod("contains", Object.class), (x$0, x$1, x$2) -> SqlVisitor.this.listContains(x$0, x$1, x$2));
                this.put(ArrayList.class.getDeclaredMethod("contains", Object.class), (x$0, x$1, x$2) -> SqlVisitor.this.listContains(x$0, x$1, x$2));
                this.put(LinkedList.class.getDeclaredMethod("contains", Object.class), (x$0, x$1, x$2) -> SqlVisitor.this.listContains(x$0, x$1, x$2));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    };
    private StringBuilder sb;
    private Expression body;
    private Expression javaMethodParameter;

    SqlVisitor(String prefix) {
        this(prefix, new LinkedListStack<List<ConstantExpression>>());
    }

    private SqlVisitor(String prefix, LinkedListStack<List<ConstantExpression>> arguments) {
        this.prefix = prefix;
        this.arguments = arguments;
        this.sb = new StringBuilder();
    }

    private static String toSqlOperator(int expressionType) {
        switch (expressionType) {
            case 10: {
                return "=";
            }
            case 2: {
                return "AND";
            }
            case 32: {
                return "OR";
            }
            case 15: {
                return " IS NULL";
            }
            case 16: {
                return " IS NOT NULL";
            }
            case 8: {
                return "";
            }
        }
        return ExpressionType.toString(expressionType);
    }

    @Override
    public StringBuilder visit(BinaryExpression e) {
        boolean quote;
        if (e.getSecond() instanceof ParameterExpression && !this.arguments.top().isEmpty() && this.arguments.top().get(((ParameterExpression)e.getSecond()).getIndex()).getValue() == null) {
            return Expression.unary(e.getExpressionType() == 10 ? 15 : 16, Boolean.TYPE, e.getFirst()).accept(this);
        }
        boolean bl = quote = e != this.body && e.getExpressionType() == 32;
        if (quote) {
            this.sb.append('(');
        }
        e.getFirst().accept(this);
        this.sb.append(' ').append(SqlVisitor.toSqlOperator(e.getExpressionType())).append(' ');
        e.getSecond().accept(this);
        if (quote) {
            this.sb.append(')');
        }
        return this.sb;
    }

    @Override
    public StringBuilder visit(ConstantExpression e) {
        if (e.getValue() == null) {
            return this.sb.append("NULL");
        }
        if (e.getValue() instanceof LambdaExpression) {
            return ((LambdaExpression)e.getValue()).getBody().accept(this);
        }
        if (e.getValue() instanceof String || e.getValue() instanceof Temporal) {
            return this.sb.append("'").append(e.getValue()).append("'");
        }
        return this.sb.append(e.getValue().toString());
    }

    @Override
    public StringBuilder visit(InvocationExpression e) {
        if (e.getTarget() instanceof LambdaExpression) {
            List list = e.getArguments().stream().filter(x -> x instanceof ConstantExpression).map(ConstantExpression.class::cast).collect(Collectors.toList());
            if (!list.isEmpty()) {
                this.arguments.push(list);
            }
        }
        if (e.getTarget().getExpressionType() == 23 && !e.getArguments().isEmpty()) {
            this.javaMethodParameter = e.getArguments().get(0);
        }
        return e.getTarget().accept(this);
    }

    @Override
    public StringBuilder visit(LambdaExpression<?> e) {
        if (this.body == null && e.getBody() instanceof BinaryExpression) {
            this.body = e.getBody();
        }
        return e.getBody().accept(this);
    }

    @Override
    public StringBuilder visit(DelegateExpression e) {
        return e.getDelegate().accept(this);
    }

    @Override
    public StringBuilder visit(MemberExpression e) {
        if (registeredMethods.containsKey(e.getMember())) {
            return Expression.binary(registeredMethods.get(e.getMember()), e.getInstance(), this.javaMethodParameter).accept(this);
        }
        if (this.complexMethods.containsKey(e.getMember())) {
            return this.sb.append((CharSequence)this.complexMethods.get(e.getMember()).apply(e.getInstance(), this.javaMethodParameter, false));
        }
        char[] nameArray = e.getMember().getName().replaceAll("^(get)", "").toCharArray();
        nameArray[0] = Character.toLowerCase(nameArray[0]);
        String name = new String(nameArray);
        if (this.prefix == null) {
            return this.sb.append(name);
        }
        return this.sb.append(this.prefix).append(".").append(name);
    }

    @Override
    public StringBuilder visit(ParameterExpression e) {
        this.arguments.top().get(e.getIndex()).accept(this);
        if (e.getIndex() == this.arguments.top().size() - 1) {
            this.arguments.pop();
        }
        return this.sb;
    }

    @Override
    public StringBuilder visit(UnaryExpression e) {
        if (e.getExpressionType() == 29) {
            InvocationExpression invocationExpression = (InvocationExpression)e.getFirst();
            MemberExpression memberExpression = (MemberExpression)invocationExpression.getTarget();
            if (registeredMethods.containsKey(memberExpression.getMember())) {
                return Expression.logicalNot(Expression.binary(registeredMethods.get(memberExpression.getMember()), memberExpression.getInstance(), invocationExpression.getArguments().get(0))).accept(this);
            }
            if (this.complexMethods.containsKey(memberExpression.getMember())) {
                return this.sb.append((CharSequence)this.complexMethods.get(memberExpression.getMember()).apply(memberExpression.getInstance(), invocationExpression.getArguments().get(0), true));
            }
            this.sb.append("!");
            return e.getFirst().accept(this);
        }
        e.getFirst().accept(this);
        return this.sb.append(SqlVisitor.toSqlOperator(e.getExpressionType()));
    }

    private StringBuilder stringStartsWith(Expression e, Expression e1, boolean negated) {
        StringBuilder valueBuilder = e1.accept(new SqlVisitor(this.prefix, this.arguments));
        valueBuilder.insert(valueBuilder.length() - 1, '%');
        return e.accept(new SqlVisitor(this.prefix, this.arguments)).append(negated ? " NOT" : "").append(" LIKE ").append((CharSequence)valueBuilder);
    }

    private StringBuilder stringEndsWith(Expression e, Expression e1, boolean negated) {
        return e.accept(new SqlVisitor(this.prefix, this.arguments)).append(negated ? " NOT" : "").append(" LIKE ").append((CharSequence)e1.accept(new SqlVisitor(this.prefix, this.arguments)).insert(1, '%'));
    }

    private StringBuilder stringContains(Expression e, Expression e1, boolean negated) {
        StringBuilder valueBuilder = e1.accept(new SqlVisitor(this.prefix, this.arguments));
        valueBuilder.insert(1, '%').insert(valueBuilder.length() - 1, '%');
        return e.accept(new SqlVisitor(this.prefix, this.arguments)).append(negated ? " NOT" : "").append(" LIKE ").append((CharSequence)valueBuilder);
    }

    private StringBuilder listContains(Expression e, Expression e1, boolean negated) {
        List l = (List)this.arguments.pop().get(((ParameterExpression)e).getIndex()).getValue();
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        l.forEach(x -> joiner.add(x.toString()));
        return e1.accept(new SqlVisitor(this.prefix, this.arguments)).append(negated ? " NOT" : "").append(" IN ").append(joiner.toString());
    }
}

