/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries.async;

import com.github.collinalpert.java2db.queries.Queryable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface AsyncQueryable<T>
extends Queryable<T> {
    default public CompletableFuture<Optional<T>> firstAsync() {
        return CompletableFuture.supplyAsync(this::first);
    }

    default public CompletableFuture<Void> firstAsync(Consumer<? super Optional<T>> callback) {
        return this.firstAsync().thenAcceptAsync(callback);
    }

    default public CompletableFuture<List<T>> toListAsync() {
        return CompletableFuture.supplyAsync(this::toList);
    }

    default public CompletableFuture<Void> toListAsync(Consumer<? super List<T>> callback) {
        return this.toListAsync().thenAcceptAsync(callback);
    }

    default public CompletableFuture<Stream<T>> toStreamAsync() {
        return CompletableFuture.supplyAsync(this::toStream);
    }

    default public CompletableFuture<Void> toStreamAsync(Consumer<? super Stream<T>> callback) {
        return this.toStreamAsync().thenAcceptAsync(callback);
    }

    default public CompletableFuture<T[]> toArrayAsync() {
        return CompletableFuture.supplyAsync(this::toArray);
    }

    default public CompletableFuture<Void> toArrayAsync(Consumer<? super T[]> callback) {
        return this.toArrayAsync().thenAcceptAsync(callback);
    }

    default public <K> CompletableFuture<Map<K, T>> toMapAsync(Function<T, K> keyMapping) {
        return CompletableFuture.supplyAsync(() -> this.toMap(keyMapping));
    }

    default public <K> CompletableFuture<Void> toMapAsync(Function<T, K> keyMapping, Consumer<? super Map<K, T>> callback) {
        return this.toMapAsync(keyMapping).thenAcceptAsync(callback);
    }

    default public <K, V> CompletableFuture<Map<K, V>> toMapAsync(Function<T, K> keyMapping, Function<T, V> valueMapping) {
        return CompletableFuture.supplyAsync(() -> this.toMap(keyMapping, valueMapping));
    }

    default public <K, V> CompletableFuture<Void> toMapAsync(Function<T, K> keyMapping, Function<T, V> valueMapping, Consumer<? super Map<K, V>> callback) {
        return this.toMapAsync(keyMapping, valueMapping).thenAcceptAsync(callback);
    }

    default public CompletableFuture<Set<T>> toSetAsync() {
        return CompletableFuture.supplyAsync(this::toSet);
    }

    default public CompletableFuture<Void> toSetAsync(Consumer<? super Set<T>> callback) {
        return this.toSetAsync().thenAcceptAsync(callback);
    }
}

