/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.threading;

import com.github.deinok.threading.OnSuccess;
import com.github.deinok.threading.RuntimeThreadException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task<R> {
    @NotNull
    private final Promise<R> promise;

    public Task(@NotNull Callable<R> callable) {
        this.promise = new Promise<R>(callable);
    }

    public int getPriority() {
        return this.promise.getPriority();
    }

    @NotNull
    public Task<R> setPriority(int priority) {
        this.promise.setPriority(priority);
        return this;
    }

    @NotNull
    public Task<R> executeAsync() {
        this.promise.executeAsync();
        return this;
    }

    @NotNull
    public Task<R> executeSync() {
        this.promise.executeSync();
        return this;
    }

    public boolean cancel() {
        return this.promise.cancel(true);
    }

    @NotNull
    public Task<R> await() throws RuntimeThreadException {
        this.promise.await();
        return this;
    }

    @Nullable
    public R getResult() throws RuntimeThreadException {
        try {
            return (R)this.promise.executeAsync().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeThreadException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeThreadException(e);
        }
    }

    @NotNull
    public Task<R> onSuccess(@NotNull OnSuccess<R> onSuccess) {
        this.promise.setOnSuccess(onSuccess);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Promise<P>
    extends FutureTask<P> {
        @NotNull
        private final Thread thread;
        @Nullable
        private OnSuccess<P> onSuccess;

        public Promise(Callable<P> callable) {
            super(callable);
            this.thread = new Thread(this);
        }

        @NotNull
        public Promise<P> setOnSuccess(@NotNull OnSuccess<P> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        @NotNull
        public Promise<P> executeAsync() {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            }
            return this;
        }

        @NotNull
        public Promise<P> executeSync() {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.run();
            }
            return this;
        }

        public int getPriority() {
            return this.thread.getPriority();
        }

        @NotNull
        public Promise<P> setPriority(int newPriority) {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.setPriority(newPriority);
            }
            return this;
        }

        @NotNull
        public Promise<P> await() throws RuntimeThreadException {
            switch (this.thread.getState()) {
                case NEW: {
                    return this.executeAsync().await();
                }
                case RUNNABLE: {
                    this.join();
                    return this.await();
                }
                case BLOCKED: {
                    this.join();
                    return this.await();
                }
                case WAITING: {
                    this.join();
                    return this.await();
                }
                case TIMED_WAITING: {
                    this.join();
                    return this.await();
                }
                case TERMINATED: {
                    return this;
                }
            }
            throw new IllegalThreadStateException();
        }

        @Override
        protected void done() throws RuntimeThreadException {
            super.done();
            if (this.onSuccess != null) {
                try {
                    this.onSuccess.execute(this.get());
                }
                catch (ExecutionException e) {
                    throw new RuntimeThreadException(e.getCause());
                }
                catch (InterruptedException e) {
                    throw new RuntimeThreadException(e);
                }
            }
        }

        private void join() throws RuntimeThreadException {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeThreadException(e);
            }
        }
    }
}

