/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.threading;

import com.github.deinok.threading.ExecutionMode;
import com.github.deinok.threading.IPromise;
import com.github.deinok.threading.ITask;
import com.github.deinok.threading.OnException;
import com.github.deinok.threading.OnSuccess;
import com.github.deinok.threading.RuntimeThreadException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task<R>
implements ITask<R> {
    @NotNull
    private final InnerFutureTask<R> innerFutureTask;

    public Task(@NotNull Callable<R> callable) {
        this.innerFutureTask = new InnerFutureTask<R>(callable);
    }

    @Override
    public int getPriority() {
        return this.innerFutureTask.getPriority();
    }

    @Override
    @NotNull
    public Task<R> setPriority(int priority) {
        this.innerFutureTask.setPriority(priority);
        return this;
    }

    @Override
    public Task<R> execute(@NotNull ExecutionMode executionMode) {
        switch (executionMode) {
            case SYNC: {
                return this.executeSync();
            }
            case ASYNC: {
                return this.executeAsync();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    @NotNull
    public Task<R> executeAsync() {
        this.innerFutureTask.executeAsync();
        return this;
    }

    @Override
    @NotNull
    public Task<R> executeSync() {
        this.innerFutureTask.executeSync();
        return this;
    }

    @Override
    public boolean cancel() {
        return this.innerFutureTask.cancel(true);
    }

    @Override
    @NotNull
    public Task<R> await() throws RuntimeThreadException {
        this.innerFutureTask.await();
        return this;
    }

    @Override
    @Nullable
    public R getResult() throws RuntimeThreadException {
        try {
            return (R)this.innerFutureTask.executeAsync().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeThreadException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeThreadException(e);
        }
    }

    @Override
    @NotNull
    public Task<R> onSuccess(@Nullable OnSuccess<R> onSuccess) {
        this.innerFutureTask.onSuccess(onSuccess);
        return this;
    }

    @Override
    @NotNull
    public Task<R> onException(@Nullable OnException onException) {
        this.innerFutureTask.onException(onException);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InnerFutureTask<P>
    extends FutureTask<P>
    implements IPromise<P> {
        @NotNull
        private final Thread thread;
        @Nullable
        private OnSuccess<P> onSuccess;
        @Nullable
        private OnException onException;

        public InnerFutureTask(Callable<P> callable) {
            super(callable);
            this.thread = new Thread(this);
        }

        @NotNull
        public InnerFutureTask<P> executeAsync() {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            }
            return this;
        }

        @NotNull
        public InnerFutureTask<P> executeSync() {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.run();
            }
            return this;
        }

        @Override
        @NotNull
        public IPromise<P> onSuccess(@Nullable OnSuccess<P> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        @Override
        @NotNull
        public IPromise<P> onException(@Nullable OnException onException) {
            this.onException = onException;
            return this;
        }

        public int getPriority() {
            return this.thread.getPriority();
        }

        @NotNull
        public InnerFutureTask<P> setPriority(int newPriority) {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.setPriority(newPriority);
            }
            return this;
        }

        @NotNull
        public InnerFutureTask<P> await() throws RuntimeThreadException {
            switch (this.thread.getState()) {
                case NEW: {
                    return this.executeAsync().await();
                }
                case RUNNABLE: {
                    this.join();
                    return this.await();
                }
                case BLOCKED: {
                    this.join();
                    return this.await();
                }
                case WAITING: {
                    this.join();
                    return this.await();
                }
                case TIMED_WAITING: {
                    this.join();
                    return this.await();
                }
                case TERMINATED: {
                    return this;
                }
            }
            throw new IllegalThreadStateException();
        }

        @Override
        protected void done() throws RuntimeThreadException {
            super.done();
            Object result = null;
            try {
                result = this.get();
            }
            catch (InterruptedException e) {
                this.executeOnException(new RuntimeThreadException(e.getCause()));
            }
            catch (ExecutionException e) {
                this.executeOnException(new RuntimeThreadException(e.getCause()));
            }
            try {
                if (this.onSuccess != null) {
                    this.onSuccess.execute(result);
                }
            }
            catch (Exception e) {
                this.executeOnException(new RuntimeThreadException(e));
            }
        }

        private void join() throws RuntimeThreadException {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeThreadException(e);
            }
        }

        private void executeOnException(@Nullable RuntimeThreadException runtimeThreadException) {
            if (runtimeThreadException != null) {
                if (this.onException != null) {
                    this.onException.execute(runtimeThreadException);
                } else {
                    throw runtimeThreadException;
                }
            }
        }
    }
}

