/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.struct;

import develop.toolkit.struct.Extractable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public abstract class EntityChain<T extends Extractable<E>, E>
implements Serializable {
    private static final long serialVersionUID = -4873465907902104664L;
    protected List<T> chain = new LinkedList<T>();

    public EntityChain() {
        Extractable[] defaultEntities = this.defaultEntity();
        if (defaultEntities != null) {
            Arrays.stream(defaultEntities).forEach(this.chain::add);
        }
    }

    protected abstract T[] defaultEntity();

    public void addCustomEntities(@NonNull T[] customEntities) {
        if (customEntities == null) {
            throw new NullPointerException("customEntities is marked @NonNull but is null");
        }
        this.chain.addAll(Arrays.asList(customEntities));
    }

    public Optional<T> extract(E parameter) {
        for (Extractable entity : this.chain) {
            if (!entity.accept(parameter)) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    public T extractRequired(E parameter, RuntimeException customRuntimeException) {
        for (Extractable entity : this.chain) {
            if (!entity.accept(parameter)) continue;
            return (T)entity;
        }
        throw customRuntimeException;
    }

    public T extractOrDefault(E parameter, T defaultValue) {
        for (Extractable entity : this.chain) {
            if (!entity.accept(parameter)) continue;
            return (T)entity;
        }
        return defaultValue;
    }

    public List<T> getChain() {
        return this.chain;
    }
}

