/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ExcelReader;
import com.github.developframework.excel.ExcelType;
import com.github.developframework.excel.ExcelWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelIO {
    public static final ExcelWriter writer(ExcelType excelType, OutputStream os) {
        HSSFWorkbook workbook;
        switch (excelType) {
            case XLS: {
                workbook = new HSSFWorkbook();
                break;
            }
            case XLSX: {
                workbook = new XSSFWorkbook();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new ExcelWriter((Workbook)workbook, os);
    }

    public static final ExcelWriter writer(ExcelType excelType, String filename) {
        try {
            return ExcelIO.writer(excelType, new FileOutputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final ExcelReader reader(ExcelType excelType, InputStream inputStream) {
        HSSFWorkbook workbook;
        try {
            switch (excelType) {
                case XLS: {
                    workbook = new HSSFWorkbook(inputStream);
                    break;
                }
                case XLSX: {
                    workbook = new XSSFWorkbook(inputStream);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ExcelReader((Workbook)workbook);
    }

    public static final ExcelReader reader(ExcelType excelType, String filename) {
        try {
            return ExcelIO.reader(excelType, new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

