/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ExcelProcessor;
import com.github.developframework.excel.TableDefinition;
import com.github.developframework.excel.column.ColumnDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader
extends ExcelProcessor {
    public ExcelReader(Workbook workbook) {
        super(workbook);
    }

    public <T> List<T> read(Class<T> clazz, Integer readSize, TableDefinition tableDefinition) {
        LinkedList<T> list = new LinkedList<T>();
        Sheet sheet = this.getSheet(this.workbook, tableDefinition);
        int lastRowNum = sheet.getLastRowNum();
        int size = (readSize == null || readSize >= lastRowNum ? lastRowNum : readSize) - tableDefinition.row();
        int rowIndex = tableDefinition.row() + (tableDefinition.hasHeader() ? 1 : 0);
        int columnIndex = tableDefinition.column();
        ColumnDefinition[] columnDefinitions = tableDefinition.columnDefinitions(this.workbook);
        for (int i = 0; i < size; ++i) {
            Row row = sheet.getRow(rowIndex + i);
            try {
                T item = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (int j = 0; j < columnDefinitions.length; ++j) {
                    ColumnDefinition columnDefinition = columnDefinitions[j];
                    if (columnDefinition == null) continue;
                    Cell cell = row.getCell(columnIndex + j);
                    columnDefinition.readData(cell, item);
                }
                list.add(item);
                continue;
            }
            catch (Exception e) {
                System.out.println(i);
                throw new RuntimeException(e);
            }
        }
        return new ArrayList(list);
    }

    private Sheet getSheet(Workbook workbook, TableDefinition tableDefinition) {
        if (tableDefinition.sheet() != null) {
            return workbook.getSheetAt(tableDefinition.sheet().intValue());
        }
        if (tableDefinition.sheetName() != null) {
            return workbook.getSheet(tableDefinition.sheetName());
        }
        throw new RuntimeException("sheet name and index is null");
    }

    public <T> List<T> readAndClose(Class<T> clazz, Integer readSize, TableDefinition tableDefinition) {
        List<T> list = this.read(clazz, readSize, tableDefinition);
        this.close();
        return list;
    }

    public void close() {
        try {
            this.workbook.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

