/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ExcelProcessor;
import com.github.developframework.excel.ExtraOperate;
import com.github.developframework.excel.TableDefinition;
import com.github.developframework.excel.column.ColumnDefinition;
import com.github.developframework.excel.column.FormulaColumnDefinition;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;

public class ExcelWriter
extends ExcelProcessor {
    private OutputStream outputStream;

    public ExcelWriter(Workbook workbook, OutputStream outputStream) {
        super(workbook);
        this.outputStream = outputStream;
    }

    public <T> ExcelWriter fillData(List<T> data, TableDefinition tableDefinition) {
        this.dealFillData(this.workbook, data, tableDefinition, null);
        return this;
    }

    public <T> ExcelWriter fillData(List<T> data, TableDefinition tableDefinition, ExtraOperate extraOperate) {
        this.dealFillData(this.workbook, data, tableDefinition, extraOperate);
        return this;
    }

    public <T> ExcelWriter fillData(T[] data, TableDefinition tableDefinition) {
        this.dealFillData(this.workbook, Arrays.asList(data), tableDefinition, null);
        return this;
    }

    public <T> ExcelWriter fillData(T[] data, TableDefinition tableDefinition, ExtraOperate extraOperate) {
        this.dealFillData(this.workbook, Arrays.asList(data), tableDefinition, extraOperate);
        return this;
    }

    public void write() {
        try {
            IOUtils.write((Workbook)this.workbook, (OutputStream)this.outputStream);
            this.workbook.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void dealFillData(Workbook workbook, List<T> list, TableDefinition tableDefinition, ExtraOperate extraOperate) {
        int i;
        int columnIndex;
        Sheet sheet = this.getSheet(workbook, tableDefinition);
        int rowIndex = tableDefinition.row();
        ColumnDefinition[] columnDefinitions = tableDefinition.columnDefinitions(workbook);
        if (tableDefinition.hasHeader()) {
            Row headerRow = sheet.createRow(rowIndex++);
            columnIndex = tableDefinition.column();
            CellStyle headerCellStyle = workbook.createCellStyle();
            tableDefinition.tableHeaderCellStyle(workbook, headerCellStyle);
            for (int i2 = 0; i2 < columnDefinitions.length; ++i2) {
                Cell headerCell = headerRow.createCell(columnIndex + i2);
                headerCell.setCellStyle(headerCellStyle);
                headerCell.setCellType(CellType.STRING);
                if (columnDefinitions[i2] == null) continue;
                headerCell.setCellValue(columnDefinitions[i2].getHeader());
            }
        }
        int[] columnCharMaxLength = new int[columnDefinitions.length];
        for (i = 0; i < list.size(); ++i) {
            T item = list.get(i);
            Row row = sheet.createRow(rowIndex + i);
            columnIndex = tableDefinition.column();
            for (int j = 0; j < columnDefinitions.length; ++j) {
                ColumnDefinition columnDefinition = columnDefinitions[j];
                if (columnDefinition == null) continue;
                Cell cell = row.createCell(columnIndex + j);
                cell.setCellType(columnDefinition.getCellType());
                cell.setCellStyle(columnDefinition.getCellStyle());
                if (columnDefinition instanceof FormulaColumnDefinition) {
                    FormulaColumnDefinition formulaColumnDefinition = (FormulaColumnDefinition)columnDefinition;
                    formulaColumnDefinition.dealFillData(cell, row.getRowNum() + 1);
                    continue;
                }
                try {
                    Object value = FieldUtils.readDeclaredField(item, (String)columnDefinition.getFieldName(), (boolean)true);
                    int length = value.toString().length();
                    columnCharMaxLength[j] = length > columnCharMaxLength[j] ? length : columnCharMaxLength[j];
                    columnDefinition.fillData(cell, value);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (extraOperate != null) {
            extraOperate.operate(workbook, sheet);
        }
        workbook.setForceFormulaRecalculation(true);
        for (i = 0; i < columnDefinitions.length; ++i) {
            int maxLength = columnDefinitions[i].getMaxLength() != null ? columnDefinitions[i].getMaxLength() : columnCharMaxLength[i];
            sheet.setColumnWidth(i + tableDefinition.column(), (maxLength + 10) * 256);
        }
    }

    private Sheet getSheet(Workbook workbook, TableDefinition tableDefinition) {
        String sheetName = tableDefinition.sheetName() == null ? "sheet " + (workbook.getNumberOfSheets() + 1) : tableDefinition.sheetName();
        return workbook.createSheet(sheetName);
    }
}

