/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.column.ColumnDefinition;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class BasicColumnDefinition
extends ColumnDefinition {
    public BasicColumnDefinition(Workbook workbook, String header, String fieldName) {
        this.header = header;
        this.fieldName = fieldName;
        this.cellStyle = workbook.createCellStyle();
        this.cellStyle.setAlignment(HorizontalAlignment.CENTER);
        this.cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.borderThin(this.cellStyle);
        this.cellType = CellType.STRING;
    }

    public BasicColumnDefinition(Workbook workbook, String header, String fieldName, int maxLength) {
        this(workbook, header, fieldName);
        this.maxLength = maxLength;
    }

    @Override
    public void dealFillData(Cell cell, Object value) {
        cell.setCellValue(value.toString());
    }

    @Override
    public void dealReadData(Cell cell, Object instance) {
        String value = cell.getStringCellValue();
        try {
            FieldUtils.writeDeclaredField((Object)instance, (String)this.fieldName, (Object)value, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

