/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;

public abstract class ColumnDefinition {
    protected String header;
    protected CellStyle cellStyle;
    protected CellType cellType;
    protected String fieldName;
    protected Integer maxLength;

    protected void borderThin(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
    }

    public final void fillData(Cell cell, Object value) {
        if (value == null) {
            cell.setCellType(CellType.BLANK);
        } else {
            this.dealFillData(cell, value);
        }
    }

    public final void readData(Cell cell, Object instance) {
        if (instance != null) {
            Class<?> instanceClass = instance.getClass();
            if (Map.class.isAssignableFrom(instanceClass)) {
                String value = cell.getStringCellValue();
                ((Map)instance).put(this.fieldName, value);
            } else if (cell.getCellTypeEnum() != CellType.BLANK) {
                this.dealReadData(cell, instance);
            }
        }
    }

    public abstract void dealFillData(Cell var1, Object var2);

    public abstract void dealReadData(Cell var1, Object var2);

    public String getHeader() {
        return this.header;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }
}

