/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.column.BasicColumnDefinition;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;

public class DateTimeColumnDefinition
extends BasicColumnDefinition {
    public DateTimeColumnDefinition(Workbook workbook, String header, String field) {
        super(workbook, header, field);
        this.cellType = CellType.NUMERIC;
        DataFormat dataFormat = workbook.createDataFormat();
        this.cellStyle.setDataFormat(dataFormat.getFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public DateTimeColumnDefinition(Workbook workbook, String header, String field, String pattern) {
        super(workbook, header, field);
        this.cellType = CellType.NUMERIC;
        DataFormat dataFormat = workbook.createDataFormat();
        this.cellStyle.setDataFormat(dataFormat.getFormat(pattern));
    }

    public DateTimeColumnDefinition(Workbook workbook, String header, String field, String pattern, int maxLength) {
        this(workbook, header, field, pattern);
        this.maxLength = maxLength;
    }

    @Override
    public void dealFillData(Cell cell, Object value) {
        Class<?> valueClass = value.getClass();
        if (Date.class.isAssignableFrom(valueClass)) {
            cell.setCellValue((Date)value);
        } else if (Calendar.class.isAssignableFrom(valueClass)) {
            cell.setCellValue((Calendar)value);
        }
    }

    @Override
    public void dealReadData(Cell cell, Object instance) {
        Class<?> instanceClass = instance.getClass();
        Field field = FieldUtils.getField(instanceClass, (String)this.fieldName, (boolean)true);
        if (field.getType() == Date.class) {
            try {
                FieldUtils.writeDeclaredField((Object)instance, (String)this.fieldName, (Object)cell.getDateCellValue(), (boolean)true);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

