/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.column.ColumnDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class FormulaColumnDefinition
extends ColumnDefinition {
    private String formula;

    public FormulaColumnDefinition(Workbook workbook, String header, String formula, String format, int maxLength) {
        this.header = header;
        this.formula = formula;
        this.cellStyle = workbook.createCellStyle();
        this.cellStyle.setAlignment(HorizontalAlignment.CENTER);
        this.cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.borderThin(this.cellStyle);
        this.cellType = CellType.FORMULA;
        if (StringUtils.isNotBlank((CharSequence)format)) {
            DataFormat dataFormat = workbook.createDataFormat();
            this.cellStyle.setDataFormat(dataFormat.getFormat(format));
        }
        this.maxLength = maxLength;
    }

    @Override
    public void dealFillData(Cell cell, Object row) {
        cell.setCellFormula(this.formula.replaceAll("\\{row\\}", String.valueOf(row)));
    }

    @Override
    public void dealReadData(Cell cell, Object instance) {
    }
}

