/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.column.BasicColumnDefinition;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;

public class NumberColumnDefinition
extends BasicColumnDefinition {
    public NumberColumnDefinition(Workbook workbook, String header, String field) {
        super(workbook, header, field);
        this.cellType = CellType.NUMERIC;
    }

    public NumberColumnDefinition(Workbook workbook, String header, String field, String format) {
        super(workbook, header, field);
        this.cellType = CellType.NUMERIC;
        if (StringUtils.isNotBlank((CharSequence)format)) {
            DataFormat dataFormat = workbook.createDataFormat();
            this.cellStyle.setDataFormat(dataFormat.getFormat(format));
        }
    }

    public NumberColumnDefinition(Workbook workbook, String header, String field, String format, int maxLength) {
        this(workbook, header, field, format);
        this.maxLength = maxLength;
    }

    @Override
    public void dealFillData(Cell cell, Object value) {
        cell.setCellValue(Double.parseDouble(value.toString()));
    }

    @Override
    public void dealReadData(Cell cell, Object instance) {
        Class<?> instanceClass = instance.getClass();
        Field field = FieldUtils.getField(instanceClass, (String)this.fieldName, (boolean)true);
        Object[] acceptClasses = new Class[]{Integer.class, Integer.TYPE, Long.class, Long.TYPE, BigDecimal.class};
        if (ArrayUtils.contains((Object[])acceptClasses, field.getType())) {
            try {
                FieldUtils.writeDeclaredField((Object)instance, (String)this.fieldName, (Object)((int)cell.getNumericCellValue()), (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

