/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.CellStyleProvider;
import develop.toolkit.base.struct.TwoValues;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ColumnDefinition<TYPE> {
    protected Workbook workbook;
    protected String header;
    protected CellStyleProvider cellStyleProvider;
    protected String field;
    protected Integer columnWidth;
    protected String format;
    protected TwoValues<HorizontalAlignment, VerticalAlignment> alignment;
    protected DataFormatter dataFormatter;

    public ColumnDefinition(Workbook workbook, String field, String header) {
        this.workbook = workbook;
        this.field = field;
        this.header = header;
        this.dataFormatter = new DataFormatter();
    }

    protected void writeIntoCell(Object entity, Cell cell, Object fieldValue) {
        TYPE convertValue = this.writeConvertValue(entity, fieldValue);
        if (convertValue != null) {
            this.setCellValue(cell, convertValue);
        }
    }

    protected <T> Object readOutCell(Object entity, Cell cell, Class<T> clazz) {
        TYPE cellValue = this.getCellValue(cell);
        return this.readConvertValue(entity, cellValue, clazz);
    }

    protected abstract CellType getColumnCellType();

    protected abstract void setCellValue(Cell var1, TYPE var2);

    protected abstract TYPE writeConvertValue(Object var1, Object var2);

    protected abstract TYPE getCellValue(Cell var1);

    protected abstract <T> Object readConvertValue(Object var1, TYPE var2, Class<T> var3);

    public ColumnDefinition<TYPE> columnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
        return this;
    }

    public ColumnDefinition<TYPE> style(CellStyleProvider cellStyleProvider) {
        this.cellStyleProvider = cellStyleProvider;
        return this;
    }

    public ColumnDefinition<TYPE> format(String format) {
        this.format = format;
        return this;
    }

    public ColumnDefinition<TYPE> alignment(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this.alignment = TwoValues.of((Object)horizontalAlignment, (Object)verticalAlignment);
        return this;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public String getHeader() {
        return this.header;
    }

    public CellStyleProvider getCellStyleProvider() {
        return this.cellStyleProvider;
    }

    public String getField() {
        return this.field;
    }

    public Integer getColumnWidth() {
        return this.columnWidth;
    }

    public String getFormat() {
        return this.format;
    }

    public TwoValues<HorizontalAlignment, VerticalAlignment> getAlignment() {
        return this.alignment;
    }

    public DataFormatter getDataFormatter() {
        return this.dataFormatter;
    }
}

