/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ExcelReader;
import com.github.developframework.excel.ExcelType;
import com.github.developframework.excel.ExcelWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelIO {
    public static ExcelWriter writer(ExcelType excelType) {
        HSSFWorkbook workbook;
        switch (excelType) {
            case XLS: {
                workbook = new HSSFWorkbook();
                break;
            }
            case XLSX: {
                workbook = new XSSFWorkbook();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new ExcelWriter((Workbook)workbook);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExcelReader reader(ExcelType excelType, InputStream inputStream) {
        try (InputStream inputStream2 = inputStream;){
            switch (excelType) {
                case XLS: {
                    HSSFWorkbook workbook = new HSSFWorkbook(inputStream);
                    return new ExcelReader((Workbook)workbook);
                }
                case XLSX: {
                    HSSFWorkbook workbook = new XSSFWorkbook(inputStream);
                    return new ExcelReader((Workbook)workbook);
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ExcelReader reader(String filename) {
        try {
            return ExcelIO.reader(ExcelType.parse(filename), new FileInputStream(filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

