/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ExcelProcessor;
import com.github.developframework.excel.TableDefinition;
import com.github.developframework.excel.TableLocation;
import com.github.developframework.excel.column.BlankColumnDefinition;
import com.github.developframework.excel.column.ColumnDefinitionBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader
extends ExcelProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExcelReader.class);

    protected ExcelReader(Workbook workbook) {
        super(workbook);
    }

    public <ENTITY> List<ENTITY> read(Class<ENTITY> entityClass, TableDefinition tableDefinition) {
        return this.read(entityClass, null, tableDefinition);
    }

    public <ENTITY> List<ENTITY> read(Class<ENTITY> entityClass, Integer readSize, TableDefinition tableDefinition) {
        Sheet sheet = this.getSheet(this.workbook, tableDefinition);
        TableLocation tableLocation = tableDefinition.tableLocation();
        int totalSize = sheet.getLastRowNum() + 1 - tableLocation.getRow() - (tableDefinition.hasTitle() ? 1 : 0) - (tableDefinition.hasColumnHeader() ? 1 : 0);
        int startColumnIndex = tableLocation.getColumn();
        int rowIndex = tableLocation.getRow() + (tableDefinition.hasTitle() ? 1 : 0) + (tableDefinition.hasColumnHeader() ? 1 : 0);
        ColumnDefinition<?>[] columnDefinitions = tableDefinition.columnDefinitions(this.workbook, new ColumnDefinitionBuilder(this.workbook));
        LinkedList<ENTITY> list = new LinkedList<ENTITY>();
        int size = readSize != null && readSize < totalSize ? readSize : totalSize;
        for (int i = 0; i < size; ++i) {
            Row row = sheet.getRow(rowIndex + i);
            ColumnDefinition<?> columnDefinition = null;
            try {
                ENTITY entity = entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (int j = 0; j < columnDefinitions.length; ++j) {
                    Cell cell;
                    columnDefinition = columnDefinitions[j];
                    if (columnDefinition == null || columnDefinition instanceof BlankColumnDefinition || (cell = row.getCell(startColumnIndex + j)) == null) continue;
                    Field field = FieldUtils.getDeclaredField(entityClass, (String)columnDefinition.field, (boolean)true);
                    Object value = columnDefinition.readOutCell(entity, cell, field.getType());
                    FieldUtils.writeDeclaredField(entity, (String)columnDefinition.field, (Object)value, (boolean)true);
                }
                list.add(entity);
                continue;
            }
            catch (Exception e) {
                assert (columnDefinition != null);
                log.error("row {} column {}", (Object)row.getRowNum(), (Object)columnDefinition.field);
                throw new RuntimeException(e);
            }
        }
        return new ArrayList(list);
    }

    private Sheet getSheet(Workbook workbook, TableDefinition tableDefinition) {
        if (tableDefinition.sheet() != null) {
            return workbook.getSheetAt(tableDefinition.sheet().intValue());
        }
        if (tableDefinition.sheetName() != null) {
            return workbook.getSheet(tableDefinition.sheetName());
        }
        return workbook.getSheetAt(0);
    }
}

