/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ExcelProcessor;
import com.github.developframework.excel.PreparedTableDataHandler;
import com.github.developframework.excel.SheetExtraHandler;
import com.github.developframework.excel.TableDefinition;
import com.github.developframework.excel.TableLocation;
import com.github.developframework.excel.column.BlankColumnDefinition;
import com.github.developframework.excel.column.ColumnDefinitionBuilder;
import com.github.developframework.excel.column.FormulaColumnDefinition;
import com.github.developframework.excel.styles.DefaultCellStyles;
import com.github.developframework.expression.ExpressionUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelWriter
extends ExcelProcessor {
    protected ExcelWriter(Workbook workbook) {
        super(workbook);
    }

    public <ENTITY> ExcelWriter load(List<ENTITY> data, TableDefinition tableDefinition) {
        this.writeInternal(tableDefinition, data);
        return this;
    }

    public <ENTITY> ExcelWriter load(ENTITY[] data, TableDefinition tableDefinition) {
        this.writeInternal(tableDefinition, Arrays.asList(data));
        return this;
    }

    public void write(OutputStream outputStream) {
        try {
            this.workbook.write(outputStream);
            this.workbook.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeToFile(String filename) {
        try (FileOutputStream os = new FileOutputStream(filename);){
            this.write(os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] writeToByteArray() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.write(os);
            byte[] bytes = os.toByteArray();
            os.close();
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <ENTITY> void writeInternal(TableDefinition tableDefinition, List<ENTITY> list) {
        Sheet sheet = this.createSheet(tableDefinition);
        TableLocation tableLocation = tableDefinition.tableLocation();
        PreparedTableDataHandler<?, ?> preparedTableDataHandler = tableDefinition.preparedTableDataHandler();
        List<ENTITY> finalList = preparedTableDataHandler == null ? list : preparedTableDataHandler.handle(list);
        ColumnDefinition<?>[] columnDefinitions = tableDefinition.columnDefinitions(this.workbook, new ColumnDefinitionBuilder(this.workbook));
        int startColumnIndex = tableLocation.getColumn();
        int rowIndex = tableLocation.getRow();
        if (tableDefinition.hasTitle() && tableDefinition.title() != null) {
            this.createTableTitle(sheet, rowIndex++, startColumnIndex, tableDefinition.title(), columnDefinitions.length);
        }
        if (tableDefinition.hasColumnHeader()) {
            this.createTableColumnHeader(sheet, rowIndex++, startColumnIndex, columnDefinitions);
        }
        this.createTableBody(sheet, rowIndex, startColumnIndex, columnDefinitions, finalList);
        SheetExtraHandler<?> sheetExtraHandler = tableDefinition.sheetExtraHandler();
        if (sheetExtraHandler != null) {
            sheetExtraHandler.handle(this.workbook, sheet, rowIndex, rowIndex + list.size(), list);
        }
    }

    private Sheet createSheet(TableDefinition tableDefinition) {
        if (tableDefinition.sheetName() == null) {
            return this.workbook.createSheet();
        }
        return this.workbook.createSheet(tableDefinition.sheetName());
    }

    private void createTableTitle(Sheet sheet, int rowIndex, int startColumnIndex, String title, int columnSize) {
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            Row titleRow = sheet.createRow(rowIndex);
            for (int i = startColumnIndex; i < startColumnIndex + columnSize; ++i) {
                titleRow.createCell(i).setCellStyle(DefaultCellStyles.normalCellStyle(this.workbook));
            }
            if (columnSize > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, startColumnIndex, startColumnIndex + columnSize - 1));
            }
            titleRow.getCell(startColumnIndex).setCellValue(title);
        }
    }

    private void createTableColumnHeader(Sheet sheet, int rowIndex, int startColumnIndex, ColumnDefinition<?>[] columnDefinitions) {
        Row headerRow = sheet.createRow(rowIndex);
        CellStyle headerCellStyle = DefaultCellStyles.normalCellStyle(this.workbook);
        for (int i = 0; i < columnDefinitions.length; ++i) {
            Cell headerCell = headerRow.createCell(startColumnIndex + i);
            ColumnDefinition<?> columnDefinition = columnDefinitions[i];
            if (columnDefinition == null) continue;
            headerCell.setCellStyle(headerCellStyle);
            if (columnDefinition.getHeader() == null) continue;
            headerCell.setCellValue(columnDefinition.getHeader());
        }
    }

    private <ENTITY> void createTableBody(Sheet sheet, int rowIndex, int startColumnIndex, ColumnDefinition<?>[] columnDefinitions, List<ENTITY> list) {
        int i;
        CellStyle DEFAULT_CELL_STYLE = DefaultCellStyles.normalCellStyle(this.workbook);
        for (i = 0; i < list.size(); ++i) {
            ENTITY entity = list.get(i);
            Row row = sheet.createRow(rowIndex + i);
            for (int j = 0; j < columnDefinitions.length; ++j) {
                Cell cell = row.createCell(startColumnIndex + j);
                ColumnDefinition<?> columnDefinition = columnDefinitions[j];
                if (columnDefinition == null || columnDefinition instanceof BlankColumnDefinition) {
                    cell.setCellStyle(this.configCellStyle(columnDefinitions[j], DEFAULT_CELL_STYLE, null));
                    continue;
                }
                Object fieldValue = columnDefinition instanceof FormulaColumnDefinition ? columnDefinition.getField().replaceAll("\\{\\s*row\\s*}", String.valueOf(cell.getRowIndex() + 1)).replaceAll("\\{\\s*column\\s*}", String.valueOf(cell.getColumnIndex() + 1)) : ExpressionUtils.getValue(entity, (String)columnDefinition.field);
                cell.setCellStyle(this.configCellStyle(columnDefinitions[j], DEFAULT_CELL_STYLE, fieldValue));
                columnDefinition.writeIntoCell(entity, cell, fieldValue);
            }
        }
        for (i = 0; i < columnDefinitions.length; ++i) {
            if (columnDefinitions[i].columnWidth == null) continue;
            sheet.setColumnWidth(startColumnIndex + i, columnDefinitions[i].columnWidth * 256);
        }
    }

    private CellStyle configCellStyle(ColumnDefinition<?> columnDefinition, CellStyle defaultCellStyle, Object value) {
        CellStyle cellStyle;
        CellStyle cellStyle2 = cellStyle = columnDefinition.cellStyleProvider == null ? defaultCellStyle : columnDefinition.cellStyleProvider.provide(this.workbook, defaultCellStyle, value);
        if (columnDefinition.format != null) {
            if (cellStyle == defaultCellStyle) {
                cellStyle = DefaultCellStyles.normalCellStyle(this.workbook);
            }
            cellStyle.setDataFormat(this.workbook.createDataFormat().getFormat(columnDefinition.format));
        }
        if (columnDefinition.alignment != null) {
            if (cellStyle == defaultCellStyle) {
                cellStyle = DefaultCellStyles.normalCellStyle(this.workbook);
            }
            cellStyle.setAlignment((HorizontalAlignment)columnDefinition.alignment.getFirstValue());
            cellStyle.setVerticalAlignment((VerticalAlignment)columnDefinition.alignment.getSecondValue());
        }
        return cellStyle;
    }
}

