/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.column.BlankColumnDefinition;
import com.github.developframework.excel.column.FormulaColumnDefinition;
import com.github.developframework.excel.column.MultipleLinesColumnDefinition;
import com.github.developframework.excel.column.NumericColumnDefinition;
import com.github.developframework.excel.column.StringColumnDefinition;
import org.apache.poi.ss.usermodel.Workbook;

public class ColumnDefinitionBuilder {
    private Workbook workbook;

    public ColumnDefinitionBuilder(Workbook workbook) {
        this.workbook = workbook;
    }

    public ColumnDefinition<?>[] columnDefinitions(ColumnDefinition<?> ... columnDefinitions) {
        return columnDefinitions;
    }

    public BlankColumnDefinition blank(String header) {
        return new BlankColumnDefinition(header);
    }

    public BlankColumnDefinition blank() {
        return new BlankColumnDefinition(null);
    }

    public StringColumnDefinition string(String field, String header) {
        return new StringColumnDefinition(this.workbook, field, header);
    }

    public StringColumnDefinition string(String field) {
        return new StringColumnDefinition(this.workbook, field, null);
    }

    public MultipleLinesColumnDefinition multipleLines(String field, String header) {
        return new MultipleLinesColumnDefinition(this.workbook, field, header);
    }

    public MultipleLinesColumnDefinition multipleLines(String field) {
        return new MultipleLinesColumnDefinition(this.workbook, field, null);
    }

    public NumericColumnDefinition numeric(String field, String header) {
        return new NumericColumnDefinition(this.workbook, field, header);
    }

    public NumericColumnDefinition numeric(String field) {
        return new NumericColumnDefinition(this.workbook, field, null);
    }

    public FormulaColumnDefinition formula(String formula, String header) {
        return new FormulaColumnDefinition(this.workbook, formula, header);
    }

    public FormulaColumnDefinition formula(String formula) {
        return new FormulaColumnDefinition(this.workbook, formula, null);
    }
}

