/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ColumnValueConverter;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;

public class FormulaColumnDefinition
extends ColumnDefinition<Object> {
    private String formula;
    private FormulaEvaluator formulaEvaluator;
    private FormulaReadColumnValueConverter readColumnValueConverter;

    public FormulaColumnDefinition(Workbook workbook, String field, String header) {
        super(workbook, field, header);
        this.formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
    }

    @Override
    protected CellType getColumnCellType() {
        return CellType.FORMULA;
    }

    @Override
    protected void setCellValue(Cell cell, Object convertValue) {
        cell.setCellFormula((String)convertValue);
    }

    @Override
    protected String writeConvertValue(Object entity, Object fieldValue) {
        return (String)fieldValue;
    }

    @Override
    protected Object getCellValue(Cell cell) {
        CellValue cellValue = this.formulaEvaluator.evaluate(cell);
        switch (cellValue.getCellType()) {
            case NUMERIC: {
                return cellValue.getNumberValue();
            }
            case STRING: {
                String cellStringValue = cell.getStringCellValue();
                return cellStringValue == null ? null : cellStringValue.trim();
            }
            case BOOLEAN: {
                return cellValue.getBooleanValue();
            }
        }
        return null;
    }

    @Override
    protected <T> Object readConvertValue(Object entity, Object cellValue, Class<T> fieldClass) {
        Object convertValue = this.readColumnValueConverter != null ? this.readColumnValueConverter.convert(entity, cellValue) : cellValue;
        if (convertValue == null) {
            return null;
        }
        if (fieldClass == cellValue.getClass()) {
            return convertValue;
        }
        if (fieldClass == String.class) {
            return convertValue.toString();
        }
        if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
            return Double.valueOf(convertValue.toString()).intValue();
        }
        if (fieldClass == Long.class || fieldClass == Long.TYPE) {
            return Double.valueOf(convertValue.toString()).longValue();
        }
        if (fieldClass == BigDecimal.class) {
            return new BigDecimal(convertValue.toString());
        }
        if (fieldClass == Float.class || fieldClass == Float.TYPE) {
            return Float.valueOf(Double.valueOf(convertValue.toString()).floatValue());
        }
        if (fieldClass == Double.class || fieldClass == Double.TYPE) {
            return Double.valueOf(convertValue.toString());
        }
        throw new IllegalArgumentException("can not convert from \"java.lang.String\" to \"" + fieldClass.getName() + "\"");
    }

    public <ENTITY, TARGET> FormulaColumnDefinition stringToValue(Class<TARGET> clazz, FormulaReadColumnValueConverter<ENTITY, TARGET> readColumnValueConverter) {
        this.readColumnValueConverter = readColumnValueConverter;
        return this;
    }

    public FormulaColumnDefinition formula(String formula) {
        this.formula = formula;
        return this;
    }

    public String getFormula() {
        return this.formula;
    }

    public static interface FormulaReadColumnValueConverter<ENTITY, TARGET>
    extends ColumnValueConverter<ENTITY, Object, TARGET> {
    }
}

