/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ColumnValueConverter;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;

public class NumericColumnDefinition
extends ColumnDefinition<Double> {
    private NumericWriteColumnValueConverter writeColumnValueConverter;
    private NumericReadColumnValueConverter readColumnValueConverter;

    public NumericColumnDefinition(Workbook workbook, String field, String header) {
        super(workbook, field, header);
    }

    @Override
    protected CellType getColumnCellType() {
        return CellType.NUMERIC;
    }

    @Override
    protected void setCellValue(Cell cell, Double convertValue) {
        cell.setCellValue(convertValue.doubleValue());
    }

    @Override
    protected Double getCellValue(Cell cell) {
        return cell.getNumericCellValue();
    }

    @Override
    protected Double writeConvertValue(Object entity, Object fieldValue) {
        if (this.writeColumnValueConverter != null) {
            fieldValue = this.writeColumnValueConverter.convert(entity, fieldValue);
        }
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof Integer) {
            return ((Integer)fieldValue).doubleValue();
        }
        if (fieldValue instanceof Long) {
            return ((Long)fieldValue).doubleValue();
        }
        if (fieldValue instanceof BigDecimal) {
            return ((BigDecimal)fieldValue).doubleValue();
        }
        if (fieldValue instanceof Float) {
            return ((Float)fieldValue).doubleValue();
        }
        if (fieldValue instanceof Double) {
            return (Double)fieldValue;
        }
        throw new IllegalArgumentException("must be Number Instance");
    }

    @Override
    protected <T> Object readConvertValue(Object entity, Double cellValue, Class<T> fieldClass) {
        Number convertValue = this.readColumnValueConverter != null ? (Number)((Number)this.readColumnValueConverter.convert(entity, cellValue)) : (Number)cellValue;
        if (convertValue == null) {
            return null;
        }
        if (fieldClass == convertValue.getClass()) {
            return convertValue;
        }
        if (fieldClass == String.class) {
            return convertValue.toString();
        }
        if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
            return convertValue.intValue();
        }
        if (fieldClass == Long.class || fieldClass == Long.TYPE) {
            return convertValue.longValue();
        }
        if (fieldClass == BigDecimal.class) {
            return new BigDecimal(convertValue.toString());
        }
        if (fieldClass == Float.class || fieldClass == Float.TYPE) {
            return Float.valueOf(convertValue.floatValue());
        }
        if (fieldClass == Double.class || fieldClass == Double.TYPE) {
            return convertValue.doubleValue();
        }
        throw new IllegalArgumentException("can not convert from \"java.lang.Double\" to \"" + fieldClass.getName() + "\"");
    }

    public <ENTITY, SOURCE> NumericColumnDefinition valueToDouble(Class<SOURCE> clazz, NumericWriteColumnValueConverter<ENTITY, SOURCE> writeColumnValueConverter) {
        this.writeColumnValueConverter = writeColumnValueConverter;
        return this;
    }

    public <ENTITY, TARGET extends Number> NumericColumnDefinition doubleToValue(Class<TARGET> clazz, NumericReadColumnValueConverter<ENTITY, TARGET> readColumnValueConverter) {
        this.readColumnValueConverter = readColumnValueConverter;
        return this;
    }

    public static interface NumericReadColumnValueConverter<ENTITY, TARGET extends Number>
    extends ColumnValueConverter<ENTITY, Double, TARGET> {
    }

    public static interface NumericWriteColumnValueConverter<ENTITY, SOURCE>
    extends ColumnValueConverter<ENTITY, SOURCE, Double> {
    }
}

