/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.column;

import com.github.developframework.excel.ColumnDefinition;
import com.github.developframework.excel.ColumnValueConverter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Workbook;

public class StringColumnDefinition
extends ColumnDefinition<String> {
    private StringWriteColumnValueConverter writeColumnValueConverter;
    private StringReadColumnValueConverter readColumnValueConverter;

    protected StringColumnDefinition(Workbook workbook, String field, String header) {
        super(workbook, field, header);
    }

    @Override
    protected CellType getColumnCellType() {
        return CellType.STRING;
    }

    @Override
    protected void setCellValue(Cell cell, String convertValue) {
        cell.setCellValue(convertValue);
    }

    @Override
    protected String getCellValue(Cell cell) {
        String cellValue = this.dataFormatter.formatCellValue(cell);
        return cellValue == null ? null : cellValue.trim();
    }

    @Override
    protected <T> Object readConvertValue(Object entity, String cellValue, Class<T> fieldClass) {
        String convertValue = this.readColumnValueConverter != null ? this.readColumnValueConverter.convert(entity, cellValue) : cellValue;
        if (convertValue == null) {
            return null;
        }
        if (fieldClass == convertValue.getClass()) {
            return convertValue;
        }
        if (fieldClass == String.class) {
            return convertValue;
        }
        if (fieldClass == Integer.class || fieldClass == Integer.TYPE) {
            return Integer.valueOf(convertValue.toString());
        }
        if (fieldClass == Long.class || fieldClass == Long.TYPE) {
            return Long.valueOf(convertValue.toString());
        }
        if (fieldClass == Boolean.class || fieldClass == Boolean.TYPE) {
            return Boolean.valueOf(convertValue.toString());
        }
        if (fieldClass == BigDecimal.class) {
            return new BigDecimal(convertValue.toString());
        }
        if (fieldClass == Float.class || fieldClass == Float.TYPE) {
            return Float.valueOf(convertValue.toString());
        }
        if (fieldClass == Double.class || fieldClass == Double.TYPE) {
            return Double.valueOf(convertValue.toString());
        }
        if (fieldClass == LocalDateTime.class) {
            return LocalDateTime.parse(convertValue.toString(), this.format == null ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : DateTimeFormatter.ofPattern(this.format));
        }
        if (fieldClass == LocalDate.class) {
            return LocalDate.parse(convertValue.toString(), this.format == null ? DateTimeFormatter.ISO_LOCAL_DATE : DateTimeFormatter.ofPattern(this.format));
        }
        if (fieldClass == LocalTime.class) {
            return LocalTime.parse(convertValue.toString(), this.format == null ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ofPattern(this.format));
        }
        throw new IllegalArgumentException("can not convert from \"java.lang.String\" to \"" + fieldClass.getName() + "\"");
    }

    @Override
    protected String writeConvertValue(Object entity, Object fieldValue) {
        if (this.writeColumnValueConverter == null) {
            return fieldValue == null ? null : fieldValue.toString();
        }
        return (String)this.writeColumnValueConverter.convert(entity, fieldValue);
    }

    public <ENTITY, SOURCE> StringColumnDefinition valueToString(Class<SOURCE> clazz, StringWriteColumnValueConverter<ENTITY, SOURCE> writeColumnValueConverter) {
        this.writeColumnValueConverter = writeColumnValueConverter;
        return this;
    }

    public <ENTITY, TARGET> StringColumnDefinition stringToValue(Class<TARGET> clazz, StringReadColumnValueConverter<ENTITY, TARGET> readColumnValueConverter) {
        this.readColumnValueConverter = readColumnValueConverter;
        return this;
    }

    public static interface StringReadColumnValueConverter<ENTITY, TARGET>
    extends ColumnValueConverter<ENTITY, String, TARGET> {
    }

    public static interface StringWriteColumnValueConverter<ENTITY, SOURCE>
    extends ColumnValueConverter<ENTITY, SOURCE, String> {
    }
}

