/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.styles;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public final class DefaultCellStyles {
    public static CellStyle normalCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        DefaultCellStyles.borderThinAndVHCenter(cellStyle);
        return cellStyle;
    }

    public static CellStyle numberCellStyle(Workbook workbook) {
        CellStyle numberCellStyle = workbook.createCellStyle();
        DefaultCellStyles.borderThinAndVHCenter(numberCellStyle);
        numberCellStyle.setDataFormat(workbook.createDataFormat().getFormat("0.00"));
        return numberCellStyle;
    }

    private static void borderThinAndVHCenter(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
    }
}

