/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.springmvc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.github.developframework.jsonview.core.JsonCreator;
import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.springmvc.res.JsonviewResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class JsonviewHttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    protected JsonviewFactory jsonviewFactory;

    public JsonviewHttpMessageConverter() {
    }

    public JsonviewHttpMessageConverter(JsonviewFactory jsonviewFactory) {
        this.jsonviewFactory = jsonviewFactory;
        this.objectMapper = jsonviewFactory.getObjectMapper();
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return JsonviewResponse.class.isAssignableFrom(clazz);
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return this.canWrite(clazz, mediaType);
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonviewResponse jsonviewResponse = (JsonviewResponse)object;
        JsonCreator creator = this.jsonviewFactory.getJsonCreator(this.objectMapper);
        JsonEncoding encoding = super.getJsonEncoding(outputMessage.getHeaders().getContentType());
        JsonGenerator generator = this.objectMapper.getFactory().createGenerator(outputMessage.getBody(), encoding);
        creator.printJson(generator, jsonviewResponse.getDataModel(), jsonviewResponse.getNamespace(), jsonviewResponse.getJsonviewId());
    }

    protected void writeInternal(Object object, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.writeInternal(object, outputMessage);
    }

    public void setJsonviewFactory(JsonviewFactory jsonviewFactory) {
        this.jsonviewFactory = jsonviewFactory;
        this.objectMapper = jsonviewFactory.getObjectMapper();
    }

    public JsonviewFactory getJsonviewFactory() {
        return this.jsonviewFactory;
    }
}

