/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.springmvc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.github.developframework.jsonview.core.JsonCreator;
import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.data.DataModel;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractJsonviewReturnValueHandler<T>
implements HandlerMethodReturnValueHandler {
    protected JsonviewFactory jsonviewFactory;

    public AbstractJsonviewReturnValueHandler(JsonviewFactory jsonviewFactory) {
        this.jsonviewFactory = jsonviewFactory;
    }

    public JsonviewFactory getJsonviewFactory() {
        return this.jsonviewFactory;
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        ServletServerHttpResponse res = new ServletServerHttpResponse(response);
        HttpHeaders headers = res.getHeaders();
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        return res;
    }

    protected JsonEncoding getJsonEncoding(MediaType contentType) {
        if (contentType != null && contentType.getCharSet() != null) {
            Charset charset = contentType.getCharSet();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.returnType().isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Assert.isInstanceOf(this.returnType(), (Object)returnValue);
        Object t = returnValue;
        mavContainer.setRequestHandled(true);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        JsonCreator creator = this.jsonviewFactory.getJsonCreator();
        JsonEncoding encoding = this.getJsonEncoding(outputMessage.getHeaders().getContentType());
        JsonGenerator generator = this.jsonviewFactory.getObjectMapper().getFactory().createGenerator(outputMessage.getBody(), encoding);
        String namespace = this.namespace(t, methodParameter);
        String jsonviewId = this.jsonviewId(t, methodParameter);
        creator.printJson(generator, this.dataModel(t), namespace, jsonviewId);
    }

    protected abstract Class<T> returnType();

    protected abstract String namespace(T var1, MethodParameter var2);

    protected abstract String jsonviewId(T var1, MethodParameter var2);

    protected abstract DataModel dataModel(T var1);
}

