/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.springmvc;

import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.data.DataModel;
import com.github.developframework.jsonview.exception.JsonviewException;
import com.github.developframework.jsonview.springmvc.AbstractJsonviewReturnValueHandler;
import com.github.developframework.jsonview.springmvc.annotation.JsonviewId;
import com.github.developframework.jsonview.springmvc.annotation.JsonviewNamespace;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;

public class DataModelReturnValueHandler
extends AbstractJsonviewReturnValueHandler<DataModel> {
    public DataModelReturnValueHandler(JsonviewFactory jsonviewFactory) {
        super(jsonviewFactory);
    }

    @Override
    protected Class<DataModel> returnType() {
        return DataModel.class;
    }

    @Override
    protected String namespace(DataModel returnValue, MethodParameter methodParameter) {
        JsonviewNamespace annotation = (JsonviewNamespace)methodParameter.getMethodAnnotation(JsonviewNamespace.class);
        if (annotation == null && (annotation = (JsonviewNamespace)AnnotationUtils.findAnnotation((Class)methodParameter.getContainingClass(), JsonviewNamespace.class)) == null) {
            throw new JsonviewException(String.format("@JsonviewNamespace is not found in Class \"%s\" with Method \"%s\".", methodParameter.getContainingClass(), methodParameter.getMethod().getName()));
        }
        return annotation.value();
    }

    @Override
    protected String jsonviewId(DataModel returnValue, MethodParameter methodParameter) {
        JsonviewId annotation = (JsonviewId)methodParameter.getMethodAnnotation(JsonviewId.class);
        if (annotation == null) {
            throw new JsonviewException(String.format("@JsonviewId is not found in Class \"%s\" with Method \"%s\".", methodParameter.getContainingClass(), methodParameter.getMethod().getName()));
        }
        return annotation.value();
    }

    @Override
    protected DataModel dataModel(DataModel returnValue) {
        return returnValue;
    }
}

