/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring.mvc;

import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.spring.mvc.AbstractKiteReturnValueHandler;
import com.github.developframework.kite.spring.mvc.annotation.KiteNamespace;
import com.github.developframework.kite.spring.mvc.annotation.TemplateId;
import com.github.developframework.kite.spring.mvc.annotation.TemplateType;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AnnotationKiteReturnValueHandler<T>
extends AbstractKiteReturnValueHandler<T> {
    public AnnotationKiteReturnValueHandler(KiteFactory kiteFactory) {
        super(kiteFactory);
    }

    @Override
    protected String namespace(T returnValue, MethodParameter methodParameter) {
        if (methodParameter.hasMethodAnnotation(KiteNamespace.class)) {
            return ((KiteNamespace)methodParameter.getMethodAnnotation(KiteNamespace.class)).value();
        }
        KiteNamespace annotation = (KiteNamespace)AnnotationUtils.findAnnotation((Class)methodParameter.getContainingClass(), KiteNamespace.class);
        if (annotation != null) {
            return annotation.value();
        }
        throw new KiteException("@KiteNamespace is not found in Class \"%s\" with Method \"%s\".", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
    }

    @Override
    protected String templateId(T returnValue, MethodParameter methodParameter) {
        if (methodParameter.hasMethodAnnotation(TemplateId.class)) {
            return ((TemplateId)methodParameter.getMethodAnnotation(TemplateId.class)).value();
        }
        throw new KiteException("@TemplateId is not found in Class \"%s\" with Method \"%s\".", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
    }

    @Override
    protected TemplateType templateType(T returnValue, MethodParameter methodParameter) {
        if (methodParameter.hasMethodAnnotation(TemplateId.class)) {
            return ((TemplateId)methodParameter.getMethodAnnotation(TemplateId.class)).type();
        }
        throw new KiteException("@TemplateId is not found in Class \"%s\" with Method \"%s\".", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
    }
}

