/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.saxparser.KiteConfigurationSaxReader;
import com.github.developframework.kite.spring.SpringResourceConfigurationSource;
import java.io.IOException;
import java.util.HashSet;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class KiteScanLoader {
    private String locations;

    public KiteScanLoader(String locations) {
        this.locations = locations;
    }

    public KiteConfiguration createKiteConfiguration() {
        String[] locationsArray = StringUtils.tokenizeToStringArray((String)this.locations, (String)",; \t\n");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            HashSet<SpringResourceConfigurationSource> sources = new HashSet<SpringResourceConfigurationSource>();
            for (String locationOne : locationsArray) {
                Resource[] resources;
                for (Resource resource : resources = resolver.getResources(locationOne)) {
                    sources.add(new SpringResourceConfigurationSource(resource));
                }
            }
            KiteConfigurationSaxReader reader = new KiteConfigurationSaxReader(sources);
            return reader.readConfiguration();
        }
        catch (IOException e) {
            throw new KiteException("Happen IOException when Spring ResourcePatternResolver get resource: %s", new Object[]{e.getMessage()});
        }
    }

    public KiteFactory createKiteFactory() {
        return new KiteFactory(new ObjectMapper(), this.createKiteConfiguration());
    }

    public KiteFactory createKiteFactory(ObjectMapper objectMapper) {
        return new KiteFactory(objectMapper, this.createKiteConfiguration());
    }

    public String getLocations() {
        return this.locations;
    }
}

