/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring.mvc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.github.developframework.kite.core.JsonProducer;
import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.XmlProducer;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.spring.KiteResponseBodyProcessor;
import com.github.developframework.kite.spring.mvc.annotation.TemplateType;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractKiteReturnValueHandler<T>
implements HandlerMethodReturnValueHandler {
    protected final KiteFactory kiteFactory;
    @Autowired(required=false)
    protected KiteResponseBodyProcessor kiteResponseBodyProcessor;

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        Assert.state((response != null ? 1 : 0) != 0, (String)"No HttpServletResponse");
        ServletServerHttpResponse res = new ServletServerHttpResponse(response);
        HttpHeaders headers = res.getHeaders();
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        return res;
    }

    protected JsonEncoding getJsonEncoding(MediaType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            Charset charset = contentType.getCharset();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.returnType().isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Assert.isInstanceOf(this.returnType(), (Object)returnValue);
        mavContainer.setRequestHandled(true);
        Object t = returnValue;
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        String namespace = this.namespace(t, methodParameter);
        String templateId = this.templateId(t, methodParameter);
        TemplateType templateType = this.templateType(t, methodParameter);
        DataModel dataModel = this.dataModel(t, methodParameter);
        switch (templateType) {
            case JSON: {
                JsonProducer jsonProducer = this.kiteFactory.getJsonProducer();
                if (this.kiteResponseBodyProcessor == null) {
                    JsonEncoding encoding = this.getJsonEncoding(outputMessage.getHeaders().getContentType());
                    JsonGenerator generator = this.kiteFactory.getObjectMapper().getFactory().createGenerator(outputMessage.getBody(), encoding);
                    jsonProducer.outputJson(generator, dataModel, namespace, templateId, false);
                    break;
                }
                OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), StandardCharsets.UTF_8);
                String json = jsonProducer.produce(dataModel, namespace, templateId, false);
                this.kiteResponseBodyProcessor.beforeWrite(methodParameter, webRequest, json);
                writer.write(json);
                writer.flush();
                break;
            }
            case XML: {
                OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), StandardCharsets.UTF_8);
                outputMessage.getHeaders().setContentType(MediaType.APPLICATION_XML);
                XmlProducer xmlProducer = this.kiteFactory.getXmlProducer();
                if (this.kiteResponseBodyProcessor == null) {
                    xmlProducer.outputXml((Writer)writer, dataModel, namespace, templateId, false);
                    break;
                }
                String xml = xmlProducer.produce(dataModel, namespace, templateId);
                this.kiteResponseBodyProcessor.beforeWrite(methodParameter, webRequest, xml);
                writer.write(xml);
                writer.flush();
            }
        }
    }

    protected abstract Class<T> returnType();

    protected abstract String namespace(T var1, MethodParameter var2);

    protected abstract String templateId(T var1, MethodParameter var2);

    protected abstract TemplateType templateType(T var1, MethodParameter var2);

    protected abstract DataModel dataModel(T var1, MethodParameter var2);

    public AbstractKiteReturnValueHandler(KiteFactory kiteFactory) {
        this.kiteFactory = kiteFactory;
    }
}

