/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.mock.db;

import com.github.developframework.mock.MockPlaceholder;
import com.github.developframework.mock.db.DBMockException;
import com.github.developframework.mock.db.InsertSQLSubmitter;
import com.github.developframework.mock.random.RandomGenerator;
import com.github.developframework.mock.random.RandomGeneratorFactory;
import com.github.developframework.toolkit.base.components.KeyValuePair;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MysqlInsertSQLSubmitter
extends InsertSQLSubmitter {
    public MysqlInsertSQLSubmitter(RandomGeneratorFactory randomGeneratorFactory) {
        super(randomGeneratorFactory);
    }

    private String build() {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        if (this.database != null) {
            sb.append("`").append(this.database).append("`.");
        }
        if (this.table == null) {
            throw new DBMockException("table is undefined");
        }
        sb.append('`').append(this.table).append("`(");
        if (this.fields.isEmpty()) {
            throw new DBMockException("fields is empty.");
        }
        sb.append(StringUtils.join((Iterable)this.fields.stream().map(pair -> "`" + (String)pair.getKey() + "`").collect(Collectors.toList()), (String)", "));
        sb.append(") VALUES(");
        sb.append(StringUtils.join((Iterable)this.fields.stream().map(pair -> "?").collect(Collectors.toList()), (String)", "));
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int submit(String driver, String url, String user, String password) throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Connection connection = DriverManager.getConnection(url, user, password);
        PreparedStatement preparedStatement = connection.prepareStatement(this.build());
        for (int i = 0; i < this.fields.size(); ++i) {
            MockPlaceholder mockPlaceholder = (MockPlaceholder)((KeyValuePair)this.fields.get(i)).getValue();
            RandomGenerator randomGenerator = this.randomGeneratorFactory.getRandomGenerator(mockPlaceholder.getName());
            Object value = randomGenerator.randomValue(mockPlaceholder, null);
            preparedStatement.setString(i + 1, value.toString());
        }
        int r = preparedStatement.executeUpdate();
        preparedStatement.close();
        connection.close();
        return r;
    }

    @Override
    public int submitBatch(String driver, String url, String user, String password, int quantity) throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        Connection connection = DriverManager.getConnection(url, user, password);
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement(this.build());
        int r = 0;
        try {
            for (int i = 0; i < quantity; ++i) {
                for (int j = 0; j < this.fields.size(); ++j) {
                    MockPlaceholder mockPlaceholder = (MockPlaceholder)((KeyValuePair)this.fields.get(j)).getValue();
                    RandomGenerator randomGenerator = this.randomGeneratorFactory.getRandomGenerator(mockPlaceholder.getName());
                    Object value = randomGenerator.randomValue(mockPlaceholder, null);
                    preparedStatement.setString(j + 1, value.toString());
                }
                r += preparedStatement.executeUpdate();
            }
        }
        catch (Exception e) {
            connection.rollback();
        }
        connection.commit();
        preparedStatement.close();
        connection.close();
        return r;
    }
}

