/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.toolkit.mail;

import com.github.developframework.toolkit.base.components.KeyValuePair;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailInfo {
    private Set<KeyValuePair<String, String>> toSet = new HashSet<KeyValuePair<String, String>>();
    private String fromName;
    private String subject;
    private String content;
    private String contentType = "text/html;charset=UTF-8";
    private String charset = "UTF-8";

    protected MimeMessage createMimeMessage(Session session, InternetAddress fromAddress) throws MessagingException {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)fromAddress);
        InternetAddress[] addresses = (InternetAddress[])this.toSet.stream().map(pair -> {
            try {
                return new InternetAddress((String)pair.getKey(), (String)pair.getValue(), this.charset);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }).toArray(InternetAddress[]::new);
        message.setRecipients(MimeMessage.RecipientType.TO, (Address[])addresses);
        message.setSubject(this.subject, this.charset);
        message.setContent((Object)this.content, this.contentType);
        message.saveChanges();
        return message;
    }

    public void addTo(String to, String toName) {
        this.toSet.add((KeyValuePair<String, String>)new KeyValuePair((Object)to, (Object)toName));
    }

    public Set<KeyValuePair<String, String>> getToSet() {
        return this.toSet;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

