/*
 * Decompiled with CFR 0.152.
 */
package com.github.devgcoder.devgmethod;

import com.github.devgcoder.devgmethod.DevgMethod;
import com.github.devgcoder.devgmethod.DevgMethodMemory;
import com.github.devgcoder.devgmethod.model.DevgMethodValue;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class DevgMethodBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> targetClass = bean.getClass();
        Map annotatedMethods = MethodIntrospector.selectMethods(targetClass, (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<DevgMethod>(){

            public DevgMethod inspect(Method method) {
                return (DevgMethod)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, DevgMethod.class);
            }
        });
        if (null == annotatedMethods || annotatedMethods.isEmpty()) {
            return bean;
        }
        for (Method method : annotatedMethods.keySet()) {
            DevgMethod devgMethod = method.getAnnotation(DevgMethod.class);
            String methodAnnotatedName = devgMethod.name();
            String desc = devgMethod.desc();
            if (DevgMethodMemory.beanMethodMap.containsKey(methodAnnotatedName)) {
                throw new RuntimeException("the devg method name" + methodAnnotatedName + " exists");
            }
            DevgMethodValue devgMethodValue = new DevgMethodValue();
            devgMethodValue.setName(methodAnnotatedName);
            devgMethodValue.setDesc(desc);
            devgMethodValue.setBeanName(beanName);
            String methodName = method.getName();
            DevgMethodMemory.beanMethodMap.put(methodAnnotatedName, methodName);
            DevgMethodMemory.annotatedMethodMap.put(methodAnnotatedName, devgMethodValue);
        }
        return bean;
    }
}

