/*
 * Decompiled with CFR 0.152.
 */
package com.github.devgcoder.devgmethod.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.devgcoder.devgmethod.DevgMethodMemory;
import com.github.devgcoder.devgmethod.model.DevgMethodValue;
import com.github.devgcoder.devgmethod.model.HttpStatusEnum;
import com.github.devgcoder.devgmethod.model.ResultModel;
import com.github.devgcoder.devgmethod.utils.DevgMethodApplicationContextUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

@RestController
@RequestMapping(value={"/devg/method"})
public class DevgMethodController {
    private final Logger logger = LoggerFactory.getLogger(DevgMethodController.class);

    @GetMapping(value={"/invokeMethod"})
    public ResultModel invokeMethod(final @RequestParam(value="methodAnnotateddName") String methodAnnotateddName) {
        DevgMethodValue devgMethodValue = DevgMethodMemory.annotatedMethodMap.get(methodAnnotateddName);
        if (null == devgMethodValue) {
            return ResultModel.newFail("devgMethodValue not exists");
        }
        String beanName = devgMethodValue.getBeanName();
        if (null == beanName || beanName.trim().equals("")) {
            return ResultModel.newFail("beanName not exists");
        }
        final Object object = DevgMethodApplicationContextUtil.getBean(beanName);
        if (null == object) {
            return ResultModel.newFail("bean not exists");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                String methodName = DevgMethodMemory.beanMethodMap.get(methodAnnotateddName);
                try {
                    Method md = object.getClass().getMethod(methodName, new Class[0]);
                    md.invoke(object, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return ResultModel.newSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/getValue"})
    public ResultModel getValue(@RequestParam(required=false, value="methodAnnotateddName") String methodAnnoName) {
        Jedis jedis = null;
        try {
            ArrayList<DevgMethodValue> results = new ArrayList<DevgMethodValue>();
            ObjectMapper objectMapper = new ObjectMapper();
            JedisPool jedisPool = DevgMethodMemory.redisConfigMap.get("jedisPool");
            jedis = jedisPool.getResource();
            if (null == methodAnnoName || methodAnnoName.trim().equals("")) {
                ArrayList<Object> objects = new ArrayList();
                Set set = jedis.keys("devg:method:value:*");
                if (null != set && set.size() > 0) {
                    Pipeline pipeline = jedis.pipelined();
                    for (String k : set) {
                        pipeline.get(k);
                    }
                    objects = pipeline.syncAndReturnAll();
                }
                for (String methodAnnotatedName : DevgMethodMemory.annotatedMethodMap.keySet()) {
                    results.add(this.getDevgMethodValue(DevgMethodMemory.annotatedMethodMap.get(methodAnnotatedName), objects, objectMapper));
                }
            } else {
                DevgMethodValue devgMethodValue = DevgMethodMemory.annotatedMethodMap.get(methodAnnoName);
                if (null == devgMethodValue) {
                    ResultModel set = ResultModel.newSuccess(results);
                    return set;
                }
                String desc = devgMethodValue.getDesc();
                String valueCachePrefixValue = "devg:method:value:" + methodAnnoName;
                String jsonStr = jedis.get(valueCachePrefixValue);
                if (null != jsonStr && !jsonStr.equals("")) {
                    devgMethodValue = (DevgMethodValue)objectMapper.readValue(jsonStr, DevgMethodValue.class);
                }
                devgMethodValue.setDesc(desc);
                results.add(devgMethodValue);
            }
            ResultModel resultModel = ResultModel.newSuccess(results);
            return resultModel;
        }
        catch (Exception ex) {
            this.logger.error("getValue error", (Throwable)ex);
            ResultModel resultModel = ResultModel.newFail(HttpStatusEnum.ERROR500.getCode(), ex.getMessage());
            return resultModel;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private DevgMethodValue getDevgMethodValue(DevgMethodValue devgMethodValue, List<Object> objects, ObjectMapper objectMapper) throws Exception {
        String methodAnnotatedName = devgMethodValue.getName();
        String desc = devgMethodValue.getDesc();
        if (null == objects || objects.size() <= 0) {
            return devgMethodValue;
        }
        for (Object object : objects) {
            devgMethodValue = (DevgMethodValue)objectMapper.readValue(object.toString(), DevgMethodValue.class);
            String name = devgMethodValue.getName();
            if (null == name || !name.equals(methodAnnotatedName)) continue;
            devgMethodValue.setDesc(desc);
            return devgMethodValue;
        }
        return devgMethodValue;
    }
}

