/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.hibernate.RowSelection;
import com.github.drinkjava2.hibernate.SQLServer2005LimitHandler;
import com.github.drinkjava2.hibernate.SQLServer2012LimitHandler;
import com.github.drinkjava2.hibernate.StringHelper;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.Map;
import javax.sql.DataSource;

public enum Dialect {
    SQLiteDialect,
    AccessDialect,
    ExcelDialect,
    TextDialect,
    ParadoxDialect,
    CobolDialect,
    XMLDialect,
    DbfDialect,
    DerbyDialect,
    OracleDialect,
    Oracle9Dialect,
    Cache71Dialect,
    CUBRIDDialect,
    DerbyTenFiveDialect,
    DataDirectOracle9Dialect,
    DB2Dialect,
    DB2390Dialect,
    DB2400Dialect,
    DerbyTenSevenDialect,
    DerbyTenSixDialect,
    FirebirdDialect,
    FrontBaseDialect,
    H2Dialect,
    HANAColumnStoreDialect,
    HANARowStoreDialect,
    HSQLDialect,
    InformixDialect,
    Informix10Dialect,
    IngresDialect,
    Ingres10Dialect,
    Ingres9Dialect,
    InterbaseDialect,
    JDataStoreDialect,
    MariaDBDialect,
    MariaDB53Dialect,
    MckoiDialect,
    MimerSQLDialect,
    MySQLDialect,
    MySQL5Dialect,
    MySQL55Dialect,
    MySQL57Dialect,
    MySQL57InnoDBDialect,
    MySQL5InnoDBDialect,
    MySQLInnoDBDialect,
    MySQLMyISAMDialect,
    Oracle8iDialect,
    Oracle9iDialect,
    Oracle10gDialect,
    Oracle12cDialect,
    PointbaseDialect,
    PostgresPlusDialect,
    PostgreSQLDialect,
    PostgreSQL81Dialect,
    PostgreSQL82Dialect,
    PostgreSQL9Dialect,
    PostgreSQL91Dialect,
    PostgreSQL92Dialect,
    PostgreSQL93Dialect,
    PostgreSQL94Dialect,
    PostgreSQL95Dialect,
    ProgressDialect,
    RDMSOS2200Dialect,
    SAPDBDialect,
    SQLServerDialect,
    SQLServer2005Dialect,
    SQLServer2008Dialect,
    SQLServer2012Dialect,
    SybaseDialect,
    Sybase11Dialect,
    SybaseAnywhereDialect,
    SybaseASE15Dialect,
    SybaseASE157Dialect,
    TeradataDialect,
    Teradata14Dialect,
    TimesTenDialect;

    private static final String SKIP_ROWS = "$SKIP_ROWS";
    private static final String PAGESIZE = "$PAGESIZE";
    private static final String TOTAL_ROWS = "$TOTAL_ROWS";
    private static final String SKIP_ROWS_PLUS1 = "$SKIP_ROWS_PLUS1";
    private static final String TOTAL_ROWS_PLUS1 = "$TOTAL_ROWS_PLUS1";
    private static final String DISTINCT_TAG = "($DISTINCT)";
    public static final String NOT_SUPPORT = "NOT_SUPPORT";
    private String sqlTemplate = null;
    private String topLimitTemplate = null;
    private Map<Type, String> typeMappings = new EnumMap<Type, String>(Type.class);

    private String processType(Type type, int ... lengths) {
        String value = this.typeMappings.get((Object)type);
        if (Type.ENGINE.equals((Object)type)) {
            return StrUtils.isEmpty(value) ? "" : value;
        }
        if (StrUtils.isEmpty(value) || "N/A".equals(value) || "n/a".equals(value)) {
            DialectException.throwEX("Type \"" + (Object)((Object)type) + "\" is not supported by dialect \"" + (Object)((Object)this) + "\"");
        }
        if (value.contains("|")) {
            String[] mappings;
            for (String mapping : mappings = StringHelper.split("|", value)) {
                if (mapping.contains("<")) {
                    String[] limitType = StringHelper.split("<", mapping);
                    if (lengths.length <= 0 || Integer.parseInt(limitType[1]) >= lengths[0]) continue;
                    return this.putParamters(type, limitType[0], lengths);
                }
                return this.putParamters(type, mapping, lengths);
            }
        } else {
            if (value.contains("$")) {
                return this.putParamters(type, value, lengths);
            }
            return value;
        }
        return "";
    }

    private String putParamters(Type type, String value, int ... lengths) {
        if (lengths.length < StrUtils.countMatches(value, '$')) {
            DialectException.throwEX("In Dialect \"" + (Object)((Object)this) + "\", Type \"" + (Object)((Object)type) + "\" should have " + StrUtils.countMatches(value, '$') + " parameters");
        }
        int i = 0;
        String newValue = value;
        if (newValue.contains("$l")) {
            newValue = StrUtils.replace(newValue, "$l", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$p")) {
            newValue = StrUtils.replace(newValue, "$p", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$s")) {
            newValue = StrUtils.replace(newValue, "$s", String.valueOf(lengths[i]));
        }
        return newValue;
    }

    public String BIGINT(int ... lengths) {
        return this.processType(Type.BIGINT, lengths);
    }

    public String BINARY(int ... lengths) {
        return this.processType(Type.BINARY, lengths);
    }

    public String BIT(int ... lengths) {
        return this.processType(Type.BIT, lengths);
    }

    public String BLOB(int ... lengths) {
        return this.processType(Type.BLOB, lengths);
    }

    public String BOOLEAN(int ... lengths) {
        return this.processType(Type.BOOLEAN, lengths);
    }

    public String CHAR(int ... lengths) {
        return this.processType(Type.CHAR, lengths);
    }

    public String CLOB(int ... lengths) {
        return this.processType(Type.CLOB, lengths);
    }

    public String DATE(int ... lengths) {
        return this.processType(Type.DATE, lengths);
    }

    public String DECIMAL(int ... lengths) {
        return this.processType(Type.DECIMAL, lengths);
    }

    public String DOUBLE(int ... lengths) {
        return this.processType(Type.DOUBLE, lengths);
    }

    public String FLOAT(int ... lengths) {
        return this.processType(Type.FLOAT, lengths);
    }

    public String INTEGER(int ... lengths) {
        return this.processType(Type.INTEGER, lengths);
    }

    public String JAVA_OBJECT(int ... lengths) {
        return this.processType(Type.JAVA_OBJECT, lengths);
    }

    public String LONGNVARCHAR(int ... lengths) {
        return this.processType(Type.LONGNVARCHAR, lengths);
    }

    public String LONGVARBINARY(int ... lengths) {
        return this.processType(Type.LONGVARBINARY, lengths);
    }

    public String LONGVARCHAR(int ... lengths) {
        return this.processType(Type.LONGVARCHAR, lengths);
    }

    public String NCHAR(int ... lengths) {
        return this.processType(Type.NCHAR, lengths);
    }

    public String NCLOB(int ... lengths) {
        return this.processType(Type.NCLOB, lengths);
    }

    public String NUMERIC(int ... lengths) {
        return this.processType(Type.NUMERIC, lengths);
    }

    public String NVARCHAR(int ... lengths) {
        return this.processType(Type.NVARCHAR, lengths);
    }

    public String OTHER(int ... lengths) {
        return this.processType(Type.OTHER, lengths);
    }

    public String REAL(int ... lengths) {
        return this.processType(Type.REAL, lengths);
    }

    public String SMALLINT(int ... lengths) {
        return this.processType(Type.SMALLINT, lengths);
    }

    public String TIME(int ... lengths) {
        return this.processType(Type.TIME, lengths);
    }

    public String TIMESTAMP(int ... lengths) {
        return this.processType(Type.TIMESTAMP, lengths);
    }

    public String TINYINT(int ... lengths) {
        return this.processType(Type.TINYINT, lengths);
    }

    public String VARBINARY(int ... lengths) {
        return this.processType(Type.VARBINARY, lengths);
    }

    public String VARCHAR(int ... lengths) {
        return this.processType(Type.VARCHAR, lengths);
    }

    public String ENGINE(int ... lengths) {
        return this.processType(Type.ENGINE, lengths);
    }

    private void initializeTypeMappings() {
        switch (this) {
            case SQLiteDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "blob");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float($p)");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "blob");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "blob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case AccessDialect: {
                this.typeMappings.put(Type.BIGINT, "integer");
                this.typeMappings.put(Type.BINARY, "binary<255|N/A");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "ole");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "varchar($l)");
                this.typeMappings.put(Type.CLOB, "longvarchar");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "currency");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "timestamp");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary<255|bit varying($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case ExcelDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "varchar($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "longvarchar");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "numeric(5,0)");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "numeric(3,0)");
                this.typeMappings.put(Type.VARBINARY, "varbinary");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case TextDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "varchar($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "numeric(5,0)");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "numeric(3,0)");
                this.typeMappings.put(Type.VARBINARY, "varbinary");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case ParadoxDialect: {
                this.typeMappings.put(Type.BIGINT, "integer");
                this.typeMappings.put(Type.BINARY, "binary");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "varchar($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "ole");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case CobolDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "varchar($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case XMLDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "varchar($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "longvarchar");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "numeric(5,0)");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "numeric(3,0)");
                this.typeMappings.put(Type.VARBINARY, "varbinary");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DbfDialect: {
                this.typeMappings.put(Type.BIGINT, "integer");
                this.typeMappings.put(Type.BINARY, "binary<255|N/A");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "varchar($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "blob");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary<255|bit varying($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case Cache71Dialect: {
                this.typeMappings.put(Type.BIGINT, "BigInt");
                this.typeMappings.put(Type.BINARY, "varbinary($1)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longvarbinary");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longvarchar");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "longvarbinary");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case CUBRIDDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "bit(8)");
                this.typeMappings.put(Type.BLOB, "bit varying(65535)");
                this.typeMappings.put(Type.BOOLEAN, "bit(8)");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "string");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "double");
                this.typeMappings.put(Type.SMALLINT, "short");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "short");
                this.typeMappings.put(Type.VARBINARY, "bit varying($l)<2000|bit varying($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<255|varchar($l)<2000|string");
                break;
            }
            case DataDirectOracle9Dialect: {
                this.typeMappings.put(Type.BIGINT, "number(19,0)");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "number(1,0)");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1 char)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "number(10,0)");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "number(5,0)");
                this.typeMappings.put(Type.TIME, "date");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "number(3,0)");
                this.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case DB2Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob($l)");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob($l)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DB2390Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob($l)");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob($l)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DB2400Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob($l)");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob($l)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob($l)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyTenFiveDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob($l)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyTenSevenDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob($l)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyTenSixDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob($l)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case FirebirdDialect: {
                this.typeMappings.put(Type.BIGINT, "numeric(18,0)");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "blob sub_type 1");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "blob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case FrontBaseDialect: {
                this.typeMappings.put(Type.BIGINT, "longint");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case H2Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar(2147483647)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "binary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case HANAColumnStoreDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "varbinary($l)<5000|blob");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "tinyint");
                this.typeMappings.put(Type.CHAR, "varchar(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float($p)");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "varbinary($l)<5000|blob");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)<5000|clob");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<5000|nclob");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)<5000|blob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<5000|clob");
                break;
            }
            case HANARowStoreDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "varbinary($l)<5000|blob");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "tinyint");
                this.typeMappings.put(Type.CHAR, "varchar(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float($p)");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "varbinary($l)<5000|blob");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)<5000|clob");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<5000|nclob");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)<5000|blob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<5000|clob");
                break;
            }
            case HSQLDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longvarbinary");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char($l)");
                this.typeMappings.put(Type.CLOB, "longvarchar");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                this.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "clob");
                this.typeMappings.put(Type.NUMERIC, "numeric");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case InformixDialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "byte");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal");
                this.typeMappings.put(Type.DOUBLE, "float");
                this.typeMappings.put(Type.FLOAT, "smallfloat");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "blob");
                this.typeMappings.put(Type.LONGVARCHAR, "clob");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "decimal");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "smallfloat");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "datetime hour to second");
                this.typeMappings.put(Type.TIMESTAMP, "datetime year to fraction(5)");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "byte");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<255|lvarchar($l)<32739|varchar($l)");
                break;
            }
            case Informix10Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "byte");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal");
                this.typeMappings.put(Type.DOUBLE, "float");
                this.typeMappings.put(Type.FLOAT, "smallfloat");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "blob");
                this.typeMappings.put(Type.LONGVARCHAR, "clob");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "decimal");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "smallfloat");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "datetime hour to second");
                this.typeMappings.put(Type.TIMESTAMP, "datetime year to fraction(5)");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "byte");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<255|lvarchar($l)<32739|varchar($l)");
                break;
            }
            case IngresDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "byte($l)<32000|long byte");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char($l)<32000|char($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                this.typeMappings.put(Type.DOUBLE, "float");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long byte");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "decimal($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time with time zone");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp with time zone");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbyte($l)<32000|long byte");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<32000|long varchar");
                break;
            }
            case Ingres10Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "byte($l)<32000|long byte");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char($l)<32000|char($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "ansidate");
                this.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                this.typeMappings.put(Type.DOUBLE, "float");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long byte");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "decimal($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time with time zone");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp(9) with time zone");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbyte($l)<32000|long byte");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<32000|long varchar");
                break;
            }
            case Ingres9Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "byte($l)<32000|long byte");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char($l)<32000|char($l)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "ansidate");
                this.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                this.typeMappings.put(Type.DOUBLE, "float");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long byte");
                this.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "decimal($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time with time zone");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp(9) with time zone");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbyte($l)<32000|long byte");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<32000|long varchar");
                break;
            }
            case InterbaseDialect: {
                this.typeMappings.put(Type.BIGINT, "numeric(18,0)");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "smallint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "blob sub_type 1");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "blob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case JDataStoreDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "varbinary");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "varchar");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case MariaDBDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MariaDB53Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime(6)");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MckoiDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case MimerSQLDialect: {
                this.typeMappings.put(Type.BIGINT, "BIGINT");
                this.typeMappings.put(Type.BINARY, "BINARY<2000|BLOB($1)");
                this.typeMappings.put(Type.BIT, "ODBC.BIT");
                this.typeMappings.put(Type.BLOB, "BLOB($l)");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "NCHAR(1)");
                this.typeMappings.put(Type.CLOB, "NCLOB($l)");
                this.typeMappings.put(Type.DATE, "DATE");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                this.typeMappings.put(Type.FLOAT, "FLOAT");
                this.typeMappings.put(Type.INTEGER, "INTEGER");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "BLOB($1)");
                this.typeMappings.put(Type.LONGVARCHAR, "CLOB($1)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "NUMERIC(19, $l)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "SMALLINT");
                this.typeMappings.put(Type.TIME, "TIME");
                this.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                this.typeMappings.put(Type.TINYINT, "ODBC.TINYINT");
                this.typeMappings.put(Type.VARBINARY, "BINARY VARYING($l)<2000|BLOB($1)");
                this.typeMappings.put(Type.VARCHAR, "NATIONAL CHARACTER VARYING($l)<2000|NCLOB($l)");
                break;
            }
            case MySQLDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<255|longtext");
                break;
            }
            case MySQL5Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MySQL55Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MySQL57Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "json");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime(6)");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MySQL57InnoDBDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "json");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime(6)");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                this.typeMappings.put(Type.ENGINE, "engine=innoDB");
                break;
            }
            case MySQL5InnoDBDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                this.typeMappings.put(Type.ENGINE, "engine=innoDB");
                break;
            }
            case MySQLInnoDBDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<255|longtext");
                this.typeMappings.put(Type.ENGINE, "engine=innoDB");
                break;
            }
            case MySQLMyISAMDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "longblob");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "longtext");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                this.typeMappings.put(Type.LONGVARCHAR, "longtext");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "longtext");
                this.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<255|longtext");
                this.typeMappings.put(Type.ENGINE, "engine=MyISAM");
                break;
            }
            case OracleDialect: {
                this.typeMappings.put(Type.BIGINT, "number(19,0)");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "number(1,0)");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "number(10,0)");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "number(5,0)");
                this.typeMappings.put(Type.TIME, "date");
                this.typeMappings.put(Type.TIMESTAMP, "date");
                this.typeMappings.put(Type.TINYINT, "number(3,0)");
                this.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.VARCHAR, "varchar2($l)<4000|long");
                break;
            }
            case Oracle10gDialect: {
                this.typeMappings.put(Type.BIGINT, "number(19,0)");
                this.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.BIT, "number(1,0)");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                this.typeMappings.put(Type.CHAR, "char(1 char)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "number(10,0)");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar2($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long raw");
                this.typeMappings.put(Type.LONGVARCHAR, "long");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar2($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "number(5,0)");
                this.typeMappings.put(Type.TIME, "date");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "number(3,0)");
                this.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case Oracle12cDialect: {
                this.typeMappings.put(Type.BIGINT, "number(19,0)");
                this.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.BIT, "number(1,0)");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                this.typeMappings.put(Type.CHAR, "char(1 char)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "number(10,0)");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar2($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long raw");
                this.typeMappings.put(Type.LONGVARCHAR, "long");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar2($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "number(5,0)");
                this.typeMappings.put(Type.TIME, "date");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "number(3,0)");
                this.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case Oracle8iDialect: {
                this.typeMappings.put(Type.BIGINT, "number(19,0)");
                this.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.BIT, "number(1,0)");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "number(10,0)");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long raw");
                this.typeMappings.put(Type.LONGVARCHAR, "long");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "number(5,0)");
                this.typeMappings.put(Type.TIME, "date");
                this.typeMappings.put(Type.TIMESTAMP, "date");
                this.typeMappings.put(Type.TINYINT, "number(3,0)");
                this.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.VARCHAR, "varchar2($l)<4000|long");
                break;
            }
            case Oracle9Dialect: {
                this.typeMappings.put(Type.BIGINT, "number(19,0)");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "number(1,0)");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1 char)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "number(10,0)");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "number(5,0)");
                this.typeMappings.put(Type.TIME, "date");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "number(3,0)");
                this.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case Oracle9iDialect: {
                this.typeMappings.put(Type.BIGINT, "number(19,0)");
                this.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.BIT, "number(1,0)");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                this.typeMappings.put(Type.CHAR, "char(1 char)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "number(10,0)");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar2($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "long raw");
                this.typeMappings.put(Type.LONGVARCHAR, "long");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar2($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "number(5,0)");
                this.typeMappings.put(Type.TIME, "date");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "number(3,0)");
                this.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                this.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case PointbaseDialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "smallint");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "blob($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgresPlusDialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQLDialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL81Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL82Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL9Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL91Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL92Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "json");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL93Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "json");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL94Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "json");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL95Dialect: {
                this.typeMappings.put(Type.BIGINT, "int8");
                this.typeMappings.put(Type.BINARY, "bytea");
                this.typeMappings.put(Type.BIT, "bool");
                this.typeMappings.put(Type.BLOB, "oid");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "float8");
                this.typeMappings.put(Type.FLOAT, "float4");
                this.typeMappings.put(Type.INTEGER, "int4");
                this.typeMappings.put(Type.JAVA_OBJECT, "json");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bytea");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "uuid");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "int2");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "int2");
                this.typeMappings.put(Type.VARBINARY, "bytea");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case ProgressDialect: {
                this.typeMappings.put(Type.BIGINT, "numeric");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "blob");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "character(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "real");
                this.typeMappings.put(Type.INTEGER, "integer");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "tinyint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case RDMSOS2200Dialect: {
                this.typeMappings.put(Type.BIGINT, "NUMERIC(21,0)");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "SMALLINT");
                this.typeMappings.put(Type.BLOB, "BLOB($l)");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "CHARACTER(1)");
                this.typeMappings.put(Type.CLOB, "clob");
                this.typeMappings.put(Type.DATE, "DATE");
                this.typeMappings.put(Type.DECIMAL, "NUMERIC(21,$l)");
                this.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                this.typeMappings.put(Type.FLOAT, "FLOAT");
                this.typeMappings.put(Type.INTEGER, "INTEGER");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "NUMERIC(21,$l)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "REAL");
                this.typeMappings.put(Type.SMALLINT, "SMALLINT");
                this.typeMappings.put(Type.TIME, "TIME");
                this.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                this.typeMappings.put(Type.TINYINT, "SMALLINT");
                this.typeMappings.put(Type.VARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.VARCHAR, "CHARACTER($l)");
                break;
            }
            case SAPDBDialect: {
                this.typeMappings.put(Type.BIGINT, "fixed(19,0)");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "boolean");
                this.typeMappings.put(Type.BLOB, "long byte");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "long varchar");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "fixed($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "timestamp");
                this.typeMappings.put(Type.TINYINT, "fixed(3,0)");
                this.typeMappings.put(Type.VARBINARY, "long byte");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SQLServerDialect: {
                this.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "image");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "datetime");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "image");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "datetime");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|image");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SQLServer2005Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "varbinary(MAX)");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "varchar(MAX)");
                this.typeMappings.put(Type.DATE, "datetime");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "varbinary(MAX)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar(MAX)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nvarchar(MAX)");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "datetime");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
                break;
            }
            case SQLServer2008Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "varbinary(MAX)");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "varchar(MAX)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "varbinary(MAX)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar(MAX)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nvarchar(MAX)");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime2");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
                break;
            }
            case SQLServer2012Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "bit");
                this.typeMappings.put(Type.BLOB, "varbinary(MAX)");
                this.typeMappings.put(Type.BOOLEAN, "bit");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "varchar(MAX)");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "varbinary(MAX)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar(MAX)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nvarchar(MAX)");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime2");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
                break;
            }
            case SybaseDialect: {
                this.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "image");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "datetime");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "datetime");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case Sybase11Dialect: {
                this.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "image");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "datetime");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "datetime");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SybaseAnywhereDialect: {
                this.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "image");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "datetime");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "datetime");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SybaseASE15Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "image");
                this.typeMappings.put(Type.BOOLEAN, "tinyint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "numeric($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "image");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SybaseASE157Dialect: {
                this.typeMappings.put(Type.BIGINT, "bigint");
                this.typeMappings.put(Type.BINARY, "binary($l)");
                this.typeMappings.put(Type.BIT, "tinyint");
                this.typeMappings.put(Type.BLOB, "image");
                this.typeMappings.put(Type.BOOLEAN, "tinyint");
                this.typeMappings.put(Type.CHAR, "char(1)");
                this.typeMappings.put(Type.CLOB, "text");
                this.typeMappings.put(Type.DATE, "date");
                this.typeMappings.put(Type.DECIMAL, "numeric($p,$s)");
                this.typeMappings.put(Type.DOUBLE, "double precision");
                this.typeMappings.put(Type.FLOAT, "float");
                this.typeMappings.put(Type.INTEGER, "int");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "image");
                this.typeMappings.put(Type.LONGVARCHAR, "text");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "smallint");
                this.typeMappings.put(Type.TIME, "time");
                this.typeMappings.put(Type.TIMESTAMP, "datetime");
                this.typeMappings.put(Type.TINYINT, "smallint");
                this.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                this.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case TeradataDialect: {
                this.typeMappings.put(Type.BIGINT, "NUMERIC(18,0)");
                this.typeMappings.put(Type.BINARY, "BYTEINT");
                this.typeMappings.put(Type.BIT, "BYTEINT");
                this.typeMappings.put(Type.BLOB, "BLOB");
                this.typeMappings.put(Type.BOOLEAN, "BYTEINT");
                this.typeMappings.put(Type.CHAR, "CHAR(1)");
                this.typeMappings.put(Type.CLOB, "CLOB");
                this.typeMappings.put(Type.DATE, "DATE");
                this.typeMappings.put(Type.DECIMAL, "DECIMAL");
                this.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                this.typeMappings.put(Type.FLOAT, "FLOAT");
                this.typeMappings.put(Type.INTEGER, "INTEGER");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "LONG VARCHAR");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "NUMERIC($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "SMALLINT");
                this.typeMappings.put(Type.TIME, "TIME");
                this.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                this.typeMappings.put(Type.TINYINT, "BYTEINT");
                this.typeMappings.put(Type.VARBINARY, "VARBYTE($l)");
                this.typeMappings.put(Type.VARCHAR, "VARCHAR($l)");
                break;
            }
            case Teradata14Dialect: {
                this.typeMappings.put(Type.BIGINT, "BIGINT");
                this.typeMappings.put(Type.BINARY, "VARBYTE(100)");
                this.typeMappings.put(Type.BIT, "BYTEINT");
                this.typeMappings.put(Type.BLOB, "BLOB");
                this.typeMappings.put(Type.BOOLEAN, "BYTEINT");
                this.typeMappings.put(Type.CHAR, "CHAR(1)");
                this.typeMappings.put(Type.CLOB, "CLOB");
                this.typeMappings.put(Type.DATE, "DATE");
                this.typeMappings.put(Type.DECIMAL, "DECIMAL");
                this.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                this.typeMappings.put(Type.FLOAT, "FLOAT");
                this.typeMappings.put(Type.INTEGER, "INTEGER");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "VARBYTE(32000)");
                this.typeMappings.put(Type.LONGVARCHAR, "VARCHAR(32000)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "NUMERIC($p,$s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "SMALLINT");
                this.typeMappings.put(Type.TIME, "TIME");
                this.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                this.typeMappings.put(Type.TINYINT, "BYTEINT");
                this.typeMappings.put(Type.VARBINARY, "VARBYTE($l)");
                this.typeMappings.put(Type.VARCHAR, "VARCHAR($l)");
                break;
            }
            case TimesTenDialect: {
                this.typeMappings.put(Type.BIGINT, "BIGINT");
                this.typeMappings.put(Type.BINARY, "N/A");
                this.typeMappings.put(Type.BIT, "TINYINT");
                this.typeMappings.put(Type.BLOB, "VARBINARY(4000000)");
                this.typeMappings.put(Type.BOOLEAN, "boolean");
                this.typeMappings.put(Type.CHAR, "CHAR(1)");
                this.typeMappings.put(Type.CLOB, "VARCHAR(4000000)");
                this.typeMappings.put(Type.DATE, "DATE");
                this.typeMappings.put(Type.DECIMAL, "N/A");
                this.typeMappings.put(Type.DOUBLE, "DOUBLE");
                this.typeMappings.put(Type.FLOAT, "FLOAT");
                this.typeMappings.put(Type.INTEGER, "INTEGER");
                this.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                this.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                this.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                this.typeMappings.put(Type.NCHAR, "nchar($l)");
                this.typeMappings.put(Type.NCLOB, "nclob");
                this.typeMappings.put(Type.NUMERIC, "DECIMAL($p, $s)");
                this.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                this.typeMappings.put(Type.OTHER, "N/A");
                this.typeMappings.put(Type.REAL, "real");
                this.typeMappings.put(Type.SMALLINT, "SMALLINT");
                this.typeMappings.put(Type.TIME, "TIME");
                this.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                this.typeMappings.put(Type.TINYINT, "TINYINT");
                this.typeMappings.put(Type.VARBINARY, "VARBINARY($l)");
                this.typeMappings.put(Type.VARCHAR, "VARCHAR($l)");
                break;
            }
        }
    }

    private String initializePaginSQLTemplate() {
        switch (this) {
            case Cache71Dialect: 
            case DB2390Dialect: 
            case FrontBaseDialect: 
            case InformixDialect: 
            case IngresDialect: 
            case JDataStoreDialect: 
            case MckoiDialect: 
            case MimerSQLDialect: 
            case PointbaseDialect: 
            case ProgressDialect: 
            case RDMSOS2200Dialect: 
            case SAPDBDialect: 
            case SQLServerDialect: 
            case SybaseDialect: 
            case Sybase11Dialect: 
            case SybaseAnywhereDialect: 
            case SybaseASE15Dialect: 
            case SybaseASE157Dialect: 
            case TeradataDialect: 
            case Teradata14Dialect: 
            case TimesTenDialect: {
                return NOT_SUPPORT;
            }
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: {
                return "WITH query AS (SELECT TMP_.*, ROW_NUMBER() OVER (ORDER BY CURRENT_TIMESTAMP) as ROW_NUM_ FROM ( select ($DISTINCT) TOP($TOTAL_ROWS) $BODY ) TMP_ ) SELECT $FIELDS_OR_ALIAS FROM query WHERE ROW_NUM_ >= $SKIP_ROWS_PLUS1 AND ROW_NUM_ < $TOTAL_ROWS_PLUS1";
            }
            case SQLiteDialect: 
            case H2Dialect: 
            case HANAColumnStoreDialect: 
            case HANARowStoreDialect: 
            case PostgresPlusDialect: 
            case PostgreSQLDialect: 
            case PostgreSQL81Dialect: 
            case PostgreSQL82Dialect: 
            case PostgreSQL9Dialect: 
            case PostgreSQL91Dialect: 
            case PostgreSQL92Dialect: 
            case PostgreSQL93Dialect: 
            case PostgreSQL94Dialect: 
            case PostgreSQL95Dialect: {
                return "select $BODY limit $PAGESIZE offset $SKIP_ROWS";
            }
            case AccessDialect: 
            case ExcelDialect: 
            case TextDialect: 
            case ParadoxDialect: 
            case CobolDialect: 
            case XMLDialect: 
            case DbfDialect: 
            case CUBRIDDialect: 
            case MariaDBDialect: 
            case MariaDB53Dialect: 
            case MySQLDialect: 
            case MySQL5Dialect: 
            case MySQL55Dialect: 
            case MySQL57Dialect: 
            case MySQL57InnoDBDialect: 
            case MySQL5InnoDBDialect: 
            case MySQLInnoDBDialect: 
            case MySQLMyISAMDialect: {
                return "select $BODY limit $SKIP_ROWS, $PAGESIZE";
            }
            case Oracle12cDialect: 
            case SQLServer2012Dialect: {
                return "select $BODY offset $SKIP_ROWS rows fetch next $PAGESIZE rows only";
            }
            case Ingres10Dialect: 
            case Ingres9Dialect: {
                return "select $BODY offset $skip_rows fetch first $pagesize rows only";
            }
            case DerbyDialect: 
            case DerbyTenFiveDialect: 
            case DerbyTenSevenDialect: 
            case DerbyTenSixDialect: {
                return "select $BODY offset $skip_rows rows fetch next $pagesize rows only";
            }
            case InterbaseDialect: {
                return "select $BODY rows $SKIP_ROWS to $PAGESIZE";
            }
            case DB2Dialect: 
            case DB2400Dialect: {
                return "select * from ( select inner2_.*, rownumber() over(order by order of inner2_) as rownumber_ from ( select $BODY fetch first $total_rows rows only ) as inner2_ ) as inner1_ where rownumber_ > $skip_rows order by rownumber_";
            }
            case OracleDialect: 
            case Oracle8iDialect: {
                return "select * from ( select row_.*, rownum rownum_ from ( select $BODY ) row_ ) where rownum_ <= $TOTAL_ROWS and rownum_ > $SKIP_ROWS";
            }
            case DataDirectOracle9Dialect: 
            case Oracle10gDialect: 
            case Oracle9Dialect: 
            case Oracle9iDialect: {
                return "select * from ( select row_.*, rownum rownum_ from ( select $BODY ) row_ where rownum <= $TOTAL_ROWS) where rownum_ > $SKIP_ROWS";
            }
            case Informix10Dialect: {
                return "select SKIP $skip_rows first $pagesize $BODY";
            }
            case FirebirdDialect: {
                return "select first $PAGESIZE skip $SKIP_ROWS $BODY";
            }
            case HSQLDialect: {
                return "select limit $SKIP_ROWS $PAGESIZE $BODY";
            }
        }
        return NOT_SUPPORT;
    }

    private String initializeTopLimitSqlTemplate() {
        switch (this) {
            case FrontBaseDialect: 
            case JDataStoreDialect: 
            case MckoiDialect: 
            case MimerSQLDialect: 
            case PointbaseDialect: 
            case ProgressDialect: 
            case SAPDBDialect: 
            case SybaseDialect: 
            case Sybase11Dialect: 
            case SybaseAnywhereDialect: 
            case SybaseASE15Dialect: 
            case SybaseASE157Dialect: 
            case TeradataDialect: 
            case Teradata14Dialect: {
                return NOT_SUPPORT;
            }
            case Oracle12cDialect: {
                return "select $BODY fetch first $PAGESIZE rows only";
            }
            case DB2Dialect: 
            case DB2390Dialect: 
            case DB2400Dialect: 
            case DerbyDialect: 
            case DerbyTenFiveDialect: 
            case DerbyTenSevenDialect: 
            case DerbyTenSixDialect: 
            case Ingres10Dialect: 
            case Ingres9Dialect: {
                return "select $BODY fetch first $pagesize rows only";
            }
            case RDMSOS2200Dialect: {
                return "select $BODY fetch first $pagesize rows only ";
            }
            case SQLiteDialect: 
            case AccessDialect: 
            case ExcelDialect: 
            case TextDialect: 
            case ParadoxDialect: 
            case CobolDialect: 
            case XMLDialect: 
            case DbfDialect: 
            case CUBRIDDialect: 
            case H2Dialect: 
            case HANAColumnStoreDialect: 
            case HANARowStoreDialect: 
            case MariaDBDialect: 
            case MariaDB53Dialect: 
            case MySQLDialect: 
            case MySQL5Dialect: 
            case MySQL55Dialect: 
            case MySQL57Dialect: 
            case MySQL57InnoDBDialect: 
            case MySQL5InnoDBDialect: 
            case MySQLInnoDBDialect: 
            case MySQLMyISAMDialect: 
            case PostgresPlusDialect: 
            case PostgreSQLDialect: 
            case PostgreSQL81Dialect: 
            case PostgreSQL82Dialect: 
            case PostgreSQL9Dialect: 
            case PostgreSQL91Dialect: 
            case PostgreSQL92Dialect: 
            case PostgreSQL93Dialect: 
            case PostgreSQL94Dialect: 
            case PostgreSQL95Dialect: {
                return "select $BODY limit $PAGESIZE";
            }
            case SQLServer2012Dialect: {
                return "select $BODY offset 0 rows fetch next $PAGESIZE rows only";
            }
            case InterbaseDialect: {
                return "select $BODY rows $PAGESIZE";
            }
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: {
                return "select ($DISTINCT) TOP($PAGESIZE) $BODY";
            }
            case Cache71Dialect: {
                return "select ($DISTINCT) top $PAGESIZE $BODY";
            }
            case SQLServerDialect: {
                return "select ($DISTINCT) top $pagesize $BODY";
            }
            case DataDirectOracle9Dialect: 
            case OracleDialect: 
            case Oracle10gDialect: 
            case Oracle8iDialect: 
            case Oracle9Dialect: 
            case Oracle9iDialect: {
                return "select * from ( select $BODY ) where rownum <= $PAGESIZE";
            }
            case FirebirdDialect: {
                return "select first $PAGESIZE $BODY";
            }
            case InformixDialect: 
            case Informix10Dialect: 
            case IngresDialect: 
            case TimesTenDialect: {
                return "select first $pagesize $BODY";
            }
            case HSQLDialect: {
                return "select top $PAGESIZE $BODY";
            }
        }
        return NOT_SUPPORT;
    }

    private static String aTopLimitSqlExample(String template) {
        String result = StrUtils.replaceIgnoreCase(template, "$SQL", "select * from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, "$BODY", "* from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, " ($DISTINCT)", "");
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS, "0");
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, "10");
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, "10");
        return result;
    }

    private static String processSQLServer(Dialect dialect, int pageNumber, int pageSize, String sql) {
        int skipRows = (pageNumber - 1) * pageSize;
        int totalRows = pageNumber * pageSize;
        RowSelection selection = new RowSelection(skipRows, totalRows);
        String result = null;
        switch (dialect) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: {
                result = new SQLServer2005LimitHandler().processSql(sql, selection);
                break;
            }
            case SQLServer2012Dialect: {
                result = new SQLServer2012LimitHandler().processSql(sql, selection);
                break;
            }
        }
        result = StringHelper.replace(result, "__hibernate_row_nr__", "_ROW_NUM_");
        result = StringHelper.replaceOnce(result, " $Top_Tag(?) ", " TOP(" + totalRows + ") ");
        result = StringHelper.replaceOnce(result, "_ROW_NUM_ >= ? AND _ROW_NUM_ < ?", "_ROW_NUM_ >= " + (skipRows + 1) + " AND _ROW_NUM_ < " + (totalRows + 1));
        result = StringHelper.replaceOnce(result, "offset ? rows fetch next ? rows only", "offset " + skipRows + " rows fetch next " + pageSize + " rows only");
        result = StringHelper.replaceOnce(result, "offset 0 rows fetch next ? rows only", "offset 0 rows fetch next " + pageSize + " rows only");
        if (StrUtils.isEmpty(result)) {
            return (String)DialectException.throwEX("Unexpected error, please report this bug");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect guessDialect(DataSource datasource) {
        Connection con = null;
        try {
            con = datasource.getConnection();
            Dialect dialect = Dialect.guessDialect(con);
            return dialect;
        }
        catch (SQLException e) {
            Dialect dialect = (Dialect)((Object)DialectException.throwEX(e, e.getMessage()));
            return dialect;
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        DialectException.throwEX(e, e.getMessage());
                    }
                }
            }
            catch (SQLException e) {
                DialectException.throwEX(e, e.getMessage());
            }
        }
    }

    public static Dialect guessDialect(Connection jdbcConnection) {
        int minorVersion;
        int majorVersion;
        String databaseName;
        try {
            DatabaseMetaData meta = jdbcConnection.getMetaData();
            databaseName = meta.getDatabaseProductName();
            majorVersion = meta.getDatabaseMajorVersion();
            minorVersion = meta.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            return (Dialect)((Object)DialectException.throwEX(e, e.getMessage()));
        }
        return Dialect.guessDialect(databaseName, majorVersion, minorVersion);
    }

    public static Dialect guessDialect(String databaseName, Object ... majorVersionMinorVersion) {
        int majorVersion = 0;
        int minorVersion = 0;
        for (int i = 0; i < majorVersionMinorVersion.length; ++i) {
            if (i == 0) {
                majorVersion = (Integer)majorVersionMinorVersion[i];
            }
            if (i != 1) continue;
            minorVersion = (Integer)majorVersionMinorVersion[i];
        }
        if ("CUBRID".equalsIgnoreCase(databaseName)) {
            return CUBRIDDialect;
        }
        if ("HSQL Database Engine".equals(databaseName)) {
            return HSQLDialect;
        }
        if ("H2".equals(databaseName)) {
            return H2Dialect;
        }
        if ("MySQL".equals(databaseName)) {
            if (majorVersion >= 5) {
                return MySQL5Dialect;
            }
            return MySQLDialect;
        }
        if ("PostgreSQL".equals(databaseName)) {
            if (majorVersion == 9) {
                if (minorVersion >= 4) {
                    return PostgreSQL94Dialect;
                }
                if (minorVersion >= 2) {
                    return PostgreSQL92Dialect;
                }
                return PostgreSQL9Dialect;
            }
            if (majorVersion == 8 && minorVersion >= 2) {
                return PostgreSQL82Dialect;
            }
            return PostgreSQL81Dialect;
        }
        if ("EnterpriseDB".equals(databaseName)) {
            return PostgresPlusDialect;
        }
        if ("Apache Derby".equals(databaseName)) {
            if (majorVersion > 10 || majorVersion == 10 && minorVersion >= 7) {
                return DerbyTenSevenDialect;
            }
            if (majorVersion == 10 && minorVersion == 6) {
                return DerbyTenSixDialect;
            }
            if (majorVersion == 10 && minorVersion == 5) {
                return DerbyTenFiveDialect;
            }
            return DerbyDialect;
        }
        if ("ingres".equalsIgnoreCase(databaseName)) {
            switch (majorVersion) {
                case 9: {
                    if (minorVersion > 2) {
                        return Ingres9Dialect;
                    }
                    return IngresDialect;
                }
                case 10: {
                    return Ingres10Dialect;
                }
            }
            return IngresDialect;
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            switch (majorVersion) {
                case 8: {
                    return SQLServerDialect;
                }
                case 9: {
                    return SQLServer2005Dialect;
                }
                case 10: {
                    return SQLServer2008Dialect;
                }
                case 11: 
                case 12: 
                case 13: {
                    return SQLServer2012Dialect;
                }
            }
            if (majorVersion < 8) {
                return SQLServerDialect;
            }
            return SQLServer2012Dialect;
        }
        if ("Sybase SQL Server".equals(databaseName) || "Adaptive Server Enterprise".equals(databaseName)) {
            return SybaseASE15Dialect;
        }
        if (databaseName.startsWith("Adaptive Server Anywhere")) {
            return SybaseAnywhereDialect;
        }
        if ("Informix Dynamic Server".equals(databaseName)) {
            return InformixDialect;
        }
        if ("DB2 UDB for AS/400".equals(databaseName)) {
            return DB2400Dialect;
        }
        if (databaseName.startsWith("DB2/")) {
            return DB2Dialect;
        }
        if ("Oracle".equals(databaseName)) {
            switch (majorVersion) {
                case 12: {
                    return Oracle12cDialect;
                }
                case 10: 
                case 11: {
                    return Oracle10gDialect;
                }
                case 9: {
                    return Oracle9iDialect;
                }
                case 8: {
                    return Oracle8iDialect;
                }
            }
            return Oracle8iDialect;
        }
        if ("HDB".equals(databaseName)) {
            return HANAColumnStoreDialect;
        }
        if (databaseName.startsWith("Firebird")) {
            return FirebirdDialect;
        }
        if (StrUtils.containsIgnoreCase(databaseName, "sqlite")) {
            return SQLiteDialect;
        }
        return null;
    }

    public String paginate(int pageNumber, int pageSize, String sql) {
        switch (this) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: 
            case SQLServer2012Dialect: {
                return Dialect.processSQLServer(this, pageNumber, pageSize, sql);
            }
        }
        if (!StrUtils.startsWithIgnoreCase(sql, "select ")) {
            return (String)DialectException.throwEX("SQL should be started with \"select \".");
        }
        String body = sql.substring(7).trim();
        if (StrUtils.isEmpty(body)) {
            return (String)DialectException.throwEX("SQL body can not be null");
        }
        int skipRows = (pageNumber - 1) * pageSize;
        int skipRowsPlus1 = skipRows + 1;
        int totalRows = pageNumber * pageSize;
        int totalRowsPlus1 = totalRows + 1;
        String useTemplate = this.sqlTemplate;
        if (skipRows == 0) {
            useTemplate = this.topLimitTemplate;
        }
        if (NOT_SUPPORT.equals(useTemplate)) {
            if (!NOT_SUPPORT.equals(this.topLimitTemplate)) {
                return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" only support top limit SQL, for example: \"" + Dialect.aTopLimitSqlExample(this.topLimitTemplate) + "\"");
            }
            return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" does not support physical pagination");
        }
        if (useTemplate.contains(DISTINCT_TAG)) {
            if (!StrUtils.startsWithIgnoreCase(body, "distinct ")) {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "");
            } else {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "distinct");
                body = body.substring(9);
            }
        }
        String result = StrUtils.replaceIgnoreCase(useTemplate, SKIP_ROWS, String.valueOf(skipRows));
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, String.valueOf(pageSize));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, String.valueOf(totalRows));
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS_PLUS1, String.valueOf(skipRowsPlus1));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS_PLUS1, String.valueOf(totalRowsPlus1));
        result = StrUtils.replace(result, "$SQL", sql);
        result = StrUtils.replace(result, "$BODY", body);
        return result;
    }

    static {
        for (Dialect d : Dialect.values()) {
            d.sqlTemplate = d.initializePaginSQLTemplate();
            d.topLimitTemplate = d.initializeTopLimitSqlTemplate();
            d.initializeTypeMappings();
        }
    }
}

