/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import java.util.ArrayList;
import java.util.List;

public class StrUtils {
    private StrUtils() {
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StrUtils.hasLength((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!StrUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StrUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!str.regionMatches(true, i, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StrUtils.hasLength(inString) || !StrUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String replaceIgnoreCase(String str, String findtxt, String replacetxt) {
        if (str == null) {
            return null;
        }
        if (findtxt == null || findtxt.length() == 0) {
            return str;
        }
        if (findtxt.length() > str.length()) {
            return str;
        }
        int counter = 0;
        while (counter < str.length() && str.substring(counter).length() >= findtxt.length()) {
            String thesubstr = str.substring(counter, counter + findtxt.length());
            if (thesubstr.equalsIgnoreCase(findtxt)) {
                str = str.substring(0, counter) + replacetxt + str.substring(counter + findtxt.length());
                counter += replacetxt.length();
                continue;
            }
            ++counter;
        }
        return str;
    }

    public static int indexOfIgnoreCase(String str, String searchStr) {
        if (searchStr.isEmpty() || str.isEmpty()) {
            return str.indexOf(searchStr);
        }
        for (int i = 0; i < str.length(); ++i) {
            char c2;
            char c;
            if (i + searchStr.length() > str.length()) {
                return -1;
            }
            int j = 0;
            for (int ii = i; ii < str.length() && j < searchStr.length() && (c = Character.toLowerCase(str.charAt(ii))) == (c2 = Character.toLowerCase(searchStr.charAt(j))); ++j, ++ii) {
            }
            if (j != searchStr.length()) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String str, String searchStr) {
        if (searchStr.isEmpty() || str.isEmpty()) {
            return -1;
        }
        return str.toLowerCase().lastIndexOf(searchStr.toLowerCase());
    }

    public static List<String> substringsBetween(String txt, String tag) {
        int i;
        ArrayList<String> l = new ArrayList<String>();
        int index = -1;
        while ((i = txt.indexOf(tag, index + 1)) != -1) {
            if (index == -1) {
                index = i;
                continue;
            }
            l.add(txt.substring(index + tag.length(), i));
            index = i;
        }
        return l;
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static int countMatches(CharSequence str, char ch) {
        if (StrUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }
}

