/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.hibernate;

import com.github.drinkjava2.hibernate.LimitHelper;
import com.github.drinkjava2.hibernate.RowSelection;
import com.github.drinkjava2.hibernate.SQLServer2005LimitHandler;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLServer2012LimitHandler
extends SQLServer2005LimitHandler {
    private boolean usedOffsetFetch;

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        if (this.hasOrderBy(sql)) {
            if (!LimitHelper.useLimit(this, selection)) {
                return sql;
            }
            return this.applyOffsetFetch(selection, sql, this.getInsertPosition(sql));
        }
        return super.processSql(sql, selection);
    }

    @Override
    public boolean useMaxForLimit() {
        return this.usedOffsetFetch ? false : super.useMaxForLimit();
    }

    @Override
    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        if (this.usedOffsetFetch) {
            return zeroBasedFirstResult;
        }
        return super.convertToFirstRowValue(zeroBasedFirstResult);
    }

    @Override
    public int bindLimitParametersAtEndOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        if (this.usedOffsetFetch && !LimitHelper.hasFirstRow(selection)) {
            statement.setInt(index, this.getMaxOrLimit(selection));
            return 1;
        }
        return super.bindLimitParametersAtEndOfQuery(selection, statement, index);
    }

    private String getOffsetFetch(RowSelection selection) {
        if (!LimitHelper.hasFirstRow(selection)) {
            return " offset 0 rows fetch next ? rows only";
        }
        return " offset ? rows fetch next ? rows only";
    }

    private int getInsertPosition(String sql) {
        char ch;
        int position;
        for (position = sql.length() - 1; position > 0 && ((ch = sql.charAt(position)) == ';' || ch == ' ' || ch == '\r' || ch == '\n'); --position) {
        }
        return position + 1;
    }

    private String applyOffsetFetch(RowSelection selection, String sql, int position) {
        this.usedOffsetFetch = true;
        StringBuilder sb = new StringBuilder();
        sb.append(sql.substring(0, position));
        sb.append(this.getOffsetFetch(selection));
        if (position > sql.length()) {
            sb.append(sql.substring(position - 1));
        }
        return sb.toString();
    }

    private boolean hasOrderBy(String sql) {
        int depth = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '(') {
                ++depth;
            } else if (ch == ')') {
                --depth;
            }
            if (depth != 0 || !sql.substring(i).toLowerCase().startsWith("order by ")) continue;
            return true;
        }
        return false;
    }
}

