/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.Type;

public class InitTypeMapping {
    protected static void initializeTypeMappings(Dialect d) {
        switch (d) {
            case SQLiteDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "blob");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float($p)");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "blob");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "blob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case AccessDialect: {
                d.typeMappings.put(Type.BIGINT, "integer");
                d.typeMappings.put(Type.BINARY, "binary<255|N/A");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "ole");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "varchar($l)");
                d.typeMappings.put(Type.CLOB, "longvarchar");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "currency");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "timestamp");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary<255|bit varying($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case ExcelDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "varchar($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "longvarchar");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "numeric(5,0)");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "numeric(3,0)");
                d.typeMappings.put(Type.VARBINARY, "varbinary");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case TextDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "varchar($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "numeric(5,0)");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "numeric(3,0)");
                d.typeMappings.put(Type.VARBINARY, "varbinary");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case ParadoxDialect: {
                d.typeMappings.put(Type.BIGINT, "integer");
                d.typeMappings.put(Type.BINARY, "binary");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "varchar($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "ole");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case CobolDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "varchar($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case XMLDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "varchar($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "longvarchar");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "numeric(5,0)");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "numeric(3,0)");
                d.typeMappings.put(Type.VARBINARY, "varbinary");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DbfDialect: {
                d.typeMappings.put(Type.BIGINT, "integer");
                d.typeMappings.put(Type.BINARY, "binary<255|N/A");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "varchar($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "java_object");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "blob");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary<255|bit varying($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case Cache71Dialect: {
                d.typeMappings.put(Type.BIGINT, "BigInt");
                d.typeMappings.put(Type.BINARY, "varbinary($1)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longvarbinary");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longvarchar");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "longvarbinary");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case CUBRIDDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "bit(8)");
                d.typeMappings.put(Type.BLOB, "bit varying(65535)");
                d.typeMappings.put(Type.BOOLEAN, "bit(8)");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "string");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "double");
                d.typeMappings.put(Type.SMALLINT, "short");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "short");
                d.typeMappings.put(Type.VARBINARY, "bit varying($l)<2000|bit varying($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<255|varchar($l)<2000|string");
                break;
            }
            case DataDirectOracle9Dialect: {
                d.typeMappings.put(Type.BIGINT, "number(19,0)");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "number(1,0)");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1 char)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "number(10,0)");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "number(5,0)");
                d.typeMappings.put(Type.TIME, "date");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "number(3,0)");
                d.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case DB2Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob($l)");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob($l)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DB2390Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob($l)");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob($l)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DB2400Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob($l)");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob($l)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob($l)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyTenFiveDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob($l)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyTenSevenDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob($l)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case DerbyTenSixDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "char($l) for bit data<254|varchar($l) for bit data");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob($l)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long varchar for bit data");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varchar($l) for bit data");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case FirebirdDialect: {
                d.typeMappings.put(Type.BIGINT, "numeric(18,0)");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "blob sub_type 1");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "blob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case FrontBaseDialect: {
                d.typeMappings.put(Type.BIGINT, "longint");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case H2Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar(2147483647)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "binary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case HANAColumnStoreDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "varbinary($l)<5000|blob");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "tinyint");
                d.typeMappings.put(Type.CHAR, "varchar(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float($p)");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "varbinary($l)<5000|blob");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)<5000|clob");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<5000|nclob");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)<5000|blob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<5000|clob");
                break;
            }
            case HANARowStoreDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "varbinary($l)<5000|blob");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "tinyint");
                d.typeMappings.put(Type.CHAR, "varchar(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float($p)");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "varbinary($l)<5000|blob");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)<5000|clob");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<5000|nclob");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)<5000|blob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<5000|clob");
                break;
            }
            case HSQLDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longvarbinary");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char($l)");
                d.typeMappings.put(Type.CLOB, "longvarchar");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "longvarbinary");
                d.typeMappings.put(Type.LONGVARCHAR, "longvarchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "clob");
                d.typeMappings.put(Type.NUMERIC, "numeric");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case InformixDialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "byte");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal");
                d.typeMappings.put(Type.DOUBLE, "float");
                d.typeMappings.put(Type.FLOAT, "smallfloat");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "blob");
                d.typeMappings.put(Type.LONGVARCHAR, "clob");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "decimal");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "smallfloat");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "datetime hour to second");
                d.typeMappings.put(Type.TIMESTAMP, "datetime year to fraction(5)");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "byte");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<255|lvarchar($l)<32739|varchar($l)");
                break;
            }
            case Informix10Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "byte");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal");
                d.typeMappings.put(Type.DOUBLE, "float");
                d.typeMappings.put(Type.FLOAT, "smallfloat");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "blob");
                d.typeMappings.put(Type.LONGVARCHAR, "clob");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "decimal");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "smallfloat");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "datetime hour to second");
                d.typeMappings.put(Type.TIMESTAMP, "datetime year to fraction(5)");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "byte");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<255|lvarchar($l)<32739|varchar($l)");
                break;
            }
            case IngresDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "byte($l)<32000|long byte");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char($l)<32000|char($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                d.typeMappings.put(Type.DOUBLE, "float");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long byte");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "decimal($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time with time zone");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp with time zone");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbyte($l)<32000|long byte");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<32000|long varchar");
                break;
            }
            case Ingres10Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "byte($l)<32000|long byte");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char($l)<32000|char($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "ansidate");
                d.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                d.typeMappings.put(Type.DOUBLE, "float");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long byte");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "decimal($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time with time zone");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp(9) with time zone");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbyte($l)<32000|long byte");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<32000|long varchar");
                break;
            }
            case Ingres9Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "byte($l)<32000|long byte");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char($l)<32000|char($l)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "ansidate");
                d.typeMappings.put(Type.DECIMAL, "decimal($p, $s)");
                d.typeMappings.put(Type.DOUBLE, "float");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long byte");
                d.typeMappings.put(Type.LONGVARCHAR, "long varchar");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "decimal($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time with time zone");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp(9) with time zone");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbyte($l)<32000|long byte");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<32000|long varchar");
                break;
            }
            case InterbaseDialect: {
                d.typeMappings.put(Type.BIGINT, "numeric(18,0)");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "smallint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "blob sub_type 1");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "blob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case JDataStoreDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "varbinary");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "varchar");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case MariaDBDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MariaDB53Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime(6)");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MckoiDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case MimerSQLDialect: {
                d.typeMappings.put(Type.BIGINT, "BIGINT");
                d.typeMappings.put(Type.BINARY, "BINARY<2000|BLOB($1)");
                d.typeMappings.put(Type.BIT, "ODBC.BIT");
                d.typeMappings.put(Type.BLOB, "BLOB($l)");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "NCHAR(1)");
                d.typeMappings.put(Type.CLOB, "NCLOB($l)");
                d.typeMappings.put(Type.DATE, "DATE");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                d.typeMappings.put(Type.FLOAT, "FLOAT");
                d.typeMappings.put(Type.INTEGER, "INTEGER");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "BLOB($1)");
                d.typeMappings.put(Type.LONGVARCHAR, "CLOB($1)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "NUMERIC(19, $l)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "SMALLINT");
                d.typeMappings.put(Type.TIME, "TIME");
                d.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                d.typeMappings.put(Type.TINYINT, "ODBC.TINYINT");
                d.typeMappings.put(Type.VARBINARY, "BINARY VARYING($l)<2000|BLOB($1)");
                d.typeMappings.put(Type.VARCHAR, "NATIONAL CHARACTER VARYING($l)<2000|NCLOB($l)");
                break;
            }
            case MySQLDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<255|longtext");
                break;
            }
            case MySQL5Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MySQL55Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MySQL57Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "json");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime(6)");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                break;
            }
            case MySQL57InnoDBDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "json");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime(6)");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                d.typeMappings.put(Type.ENGINE, "engine=innoDB");
                break;
            }
            case MySQL5InnoDBDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<65535|longtext");
                d.typeMappings.put(Type.ENGINE, "engine=innoDB");
                break;
            }
            case MySQLInnoDBDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<255|longtext");
                d.typeMappings.put(Type.ENGINE, "engine=innoDB");
                break;
            }
            case MySQLMyISAMDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "longblob");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "longtext");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
                d.typeMappings.put(Type.LONGVARCHAR, "longtext");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "longtext");
                d.typeMappings.put(Type.NUMERIC, "decimal($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<255|longtext");
                d.typeMappings.put(Type.ENGINE, "engine=MyISAM");
                break;
            }
            case OracleDialect: {
                d.typeMappings.put(Type.BIGINT, "number(19,0)");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "number(1,0)");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "number(10,0)");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "number(5,0)");
                d.typeMappings.put(Type.TIME, "date");
                d.typeMappings.put(Type.TIMESTAMP, "date");
                d.typeMappings.put(Type.TINYINT, "number(3,0)");
                d.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.VARCHAR, "varchar2($l)<4000|long");
                break;
            }
            case Oracle10gDialect: {
                d.typeMappings.put(Type.BIGINT, "number(19,0)");
                d.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.BIT, "number(1,0)");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                d.typeMappings.put(Type.CHAR, "char(1 char)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "number(10,0)");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar2($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long raw");
                d.typeMappings.put(Type.LONGVARCHAR, "long");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar2($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "number(5,0)");
                d.typeMappings.put(Type.TIME, "date");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "number(3,0)");
                d.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case Oracle12cDialect: {
                d.typeMappings.put(Type.BIGINT, "number(19,0)");
                d.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.BIT, "number(1,0)");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                d.typeMappings.put(Type.CHAR, "char(1 char)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "number(10,0)");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar2($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long raw");
                d.typeMappings.put(Type.LONGVARCHAR, "long");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar2($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "number(5,0)");
                d.typeMappings.put(Type.TIME, "date");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "number(3,0)");
                d.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case Oracle8iDialect: {
                d.typeMappings.put(Type.BIGINT, "number(19,0)");
                d.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.BIT, "number(1,0)");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "number(10,0)");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long raw");
                d.typeMappings.put(Type.LONGVARCHAR, "long");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "number(5,0)");
                d.typeMappings.put(Type.TIME, "date");
                d.typeMappings.put(Type.TIMESTAMP, "date");
                d.typeMappings.put(Type.TINYINT, "number(3,0)");
                d.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.VARCHAR, "varchar2($l)<4000|long");
                break;
            }
            case Oracle9Dialect: {
                d.typeMappings.put(Type.BIGINT, "number(19,0)");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "number(1,0)");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1 char)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "number(10,0)");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "number(5,0)");
                d.typeMappings.put(Type.TIME, "date");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "number(3,0)");
                d.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case Oracle9iDialect: {
                d.typeMappings.put(Type.BIGINT, "number(19,0)");
                d.typeMappings.put(Type.BINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.BIT, "number(1,0)");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "number(1,0)");
                d.typeMappings.put(Type.CHAR, "char(1 char)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "number($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "number(10,0)");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar2($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "long raw");
                d.typeMappings.put(Type.LONGVARCHAR, "long");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "number($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar2($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "number(5,0)");
                d.typeMappings.put(Type.TIME, "date");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "number(3,0)");
                d.typeMappings.put(Type.VARBINARY, "raw($l)<2000|long raw");
                d.typeMappings.put(Type.VARCHAR, "varchar2($l char)<4000|long");
                break;
            }
            case PointbaseDialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "smallint");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "blob($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgresPlusDialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQLDialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL81Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL82Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL9Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL91Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL92Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "json");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL93Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "json");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL94Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "json");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case PostgreSQL95Dialect: {
                d.typeMappings.put(Type.BIGINT, "int8");
                d.typeMappings.put(Type.BINARY, "bytea");
                d.typeMappings.put(Type.BIT, "bool");
                d.typeMappings.put(Type.BLOB, "oid");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "float8");
                d.typeMappings.put(Type.FLOAT, "float4");
                d.typeMappings.put(Type.INTEGER, "int4");
                d.typeMappings.put(Type.JAVA_OBJECT, "json");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bytea");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "uuid");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "int2");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "int2");
                d.typeMappings.put(Type.VARBINARY, "bytea");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case ProgressDialect: {
                d.typeMappings.put(Type.BIGINT, "numeric");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "blob");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "character(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "real");
                d.typeMappings.put(Type.INTEGER, "integer");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "tinyint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case RDMSOS2200Dialect: {
                d.typeMappings.put(Type.BIGINT, "NUMERIC(21,0)");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "SMALLINT");
                d.typeMappings.put(Type.BLOB, "BLOB($l)");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "CHARACTER(1)");
                d.typeMappings.put(Type.CLOB, "clob");
                d.typeMappings.put(Type.DATE, "DATE");
                d.typeMappings.put(Type.DECIMAL, "NUMERIC(21,$l)");
                d.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                d.typeMappings.put(Type.FLOAT, "FLOAT");
                d.typeMappings.put(Type.INTEGER, "INTEGER");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "NUMERIC(21,$l)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "REAL");
                d.typeMappings.put(Type.SMALLINT, "SMALLINT");
                d.typeMappings.put(Type.TIME, "TIME");
                d.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                d.typeMappings.put(Type.TINYINT, "SMALLINT");
                d.typeMappings.put(Type.VARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.VARCHAR, "CHARACTER($l)");
                break;
            }
            case SAPDBDialect: {
                d.typeMappings.put(Type.BIGINT, "fixed(19,0)");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "boolean");
                d.typeMappings.put(Type.BLOB, "long byte");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "long varchar");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "fixed($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "timestamp");
                d.typeMappings.put(Type.TINYINT, "fixed(3,0)");
                d.typeMappings.put(Type.VARBINARY, "long byte");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SQLServerDialect: {
                d.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "image");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "datetime");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "image");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "datetime");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|image");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SQLServer2005Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "varbinary(MAX)");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "varchar(MAX)");
                d.typeMappings.put(Type.DATE, "datetime");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "varbinary(MAX)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar(MAX)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nvarchar(MAX)");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "datetime");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
                break;
            }
            case SQLServer2008Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "varbinary(MAX)");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "varchar(MAX)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "varbinary(MAX)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar(MAX)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nvarchar(MAX)");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime2");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
                break;
            }
            case SQLServer2012Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "bit");
                d.typeMappings.put(Type.BLOB, "varbinary(MAX)");
                d.typeMappings.put(Type.BOOLEAN, "bit");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "varchar(MAX)");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "varbinary(MAX)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar(MAX)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nvarchar(MAX)");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime2");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
                break;
            }
            case SybaseDialect: {
                d.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "image");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "datetime");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "datetime");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case Sybase11Dialect: {
                d.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "image");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "datetime");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "datetime");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SybaseAnywhereDialect: {
                d.typeMappings.put(Type.BIGINT, "numeric(19,0)");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "image");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "datetime");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "datetime");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SybaseASE15Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "image");
                d.typeMappings.put(Type.BOOLEAN, "tinyint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "numeric($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "image");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case SybaseASE157Dialect: {
                d.typeMappings.put(Type.BIGINT, "bigint");
                d.typeMappings.put(Type.BINARY, "binary($l)");
                d.typeMappings.put(Type.BIT, "tinyint");
                d.typeMappings.put(Type.BLOB, "image");
                d.typeMappings.put(Type.BOOLEAN, "tinyint");
                d.typeMappings.put(Type.CHAR, "char(1)");
                d.typeMappings.put(Type.CLOB, "text");
                d.typeMappings.put(Type.DATE, "date");
                d.typeMappings.put(Type.DECIMAL, "numeric($p,$s)");
                d.typeMappings.put(Type.DOUBLE, "double precision");
                d.typeMappings.put(Type.FLOAT, "float");
                d.typeMappings.put(Type.INTEGER, "int");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "image");
                d.typeMappings.put(Type.LONGVARCHAR, "text");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "numeric($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "smallint");
                d.typeMappings.put(Type.TIME, "time");
                d.typeMappings.put(Type.TIMESTAMP, "datetime");
                d.typeMappings.put(Type.TINYINT, "smallint");
                d.typeMappings.put(Type.VARBINARY, "varbinary($l)");
                d.typeMappings.put(Type.VARCHAR, "varchar($l)");
                break;
            }
            case TeradataDialect: {
                d.typeMappings.put(Type.BIGINT, "NUMERIC(18,0)");
                d.typeMappings.put(Type.BINARY, "BYTEINT");
                d.typeMappings.put(Type.BIT, "BYTEINT");
                d.typeMappings.put(Type.BLOB, "BLOB");
                d.typeMappings.put(Type.BOOLEAN, "BYTEINT");
                d.typeMappings.put(Type.CHAR, "CHAR(1)");
                d.typeMappings.put(Type.CLOB, "CLOB");
                d.typeMappings.put(Type.DATE, "DATE");
                d.typeMappings.put(Type.DECIMAL, "DECIMAL");
                d.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                d.typeMappings.put(Type.FLOAT, "FLOAT");
                d.typeMappings.put(Type.INTEGER, "INTEGER");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "LONG VARCHAR");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "NUMERIC($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "SMALLINT");
                d.typeMappings.put(Type.TIME, "TIME");
                d.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                d.typeMappings.put(Type.TINYINT, "BYTEINT");
                d.typeMappings.put(Type.VARBINARY, "VARBYTE($l)");
                d.typeMappings.put(Type.VARCHAR, "VARCHAR($l)");
                break;
            }
            case Teradata14Dialect: {
                d.typeMappings.put(Type.BIGINT, "BIGINT");
                d.typeMappings.put(Type.BINARY, "VARBYTE(100)");
                d.typeMappings.put(Type.BIT, "BYTEINT");
                d.typeMappings.put(Type.BLOB, "BLOB");
                d.typeMappings.put(Type.BOOLEAN, "BYTEINT");
                d.typeMappings.put(Type.CHAR, "CHAR(1)");
                d.typeMappings.put(Type.CLOB, "CLOB");
                d.typeMappings.put(Type.DATE, "DATE");
                d.typeMappings.put(Type.DECIMAL, "DECIMAL");
                d.typeMappings.put(Type.DOUBLE, "DOUBLE PRECISION");
                d.typeMappings.put(Type.FLOAT, "FLOAT");
                d.typeMappings.put(Type.INTEGER, "INTEGER");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "VARBYTE(32000)");
                d.typeMappings.put(Type.LONGVARCHAR, "VARCHAR(32000)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "NUMERIC($p,$s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "SMALLINT");
                d.typeMappings.put(Type.TIME, "TIME");
                d.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                d.typeMappings.put(Type.TINYINT, "BYTEINT");
                d.typeMappings.put(Type.VARBINARY, "VARBYTE($l)");
                d.typeMappings.put(Type.VARCHAR, "VARCHAR($l)");
                break;
            }
            case TimesTenDialect: {
                d.typeMappings.put(Type.BIGINT, "BIGINT");
                d.typeMappings.put(Type.BINARY, "N/A");
                d.typeMappings.put(Type.BIT, "TINYINT");
                d.typeMappings.put(Type.BLOB, "VARBINARY(4000000)");
                d.typeMappings.put(Type.BOOLEAN, "boolean");
                d.typeMappings.put(Type.CHAR, "CHAR(1)");
                d.typeMappings.put(Type.CLOB, "VARCHAR(4000000)");
                d.typeMappings.put(Type.DATE, "DATE");
                d.typeMappings.put(Type.DECIMAL, "N/A");
                d.typeMappings.put(Type.DOUBLE, "DOUBLE");
                d.typeMappings.put(Type.FLOAT, "FLOAT");
                d.typeMappings.put(Type.INTEGER, "INTEGER");
                d.typeMappings.put(Type.JAVA_OBJECT, "N/A");
                d.typeMappings.put(Type.LONGNVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.LONGVARBINARY, "bit varying($l)");
                d.typeMappings.put(Type.LONGVARCHAR, "varchar($l)");
                d.typeMappings.put(Type.NCHAR, "nchar($l)");
                d.typeMappings.put(Type.NCLOB, "nclob");
                d.typeMappings.put(Type.NUMERIC, "DECIMAL($p, $s)");
                d.typeMappings.put(Type.NVARCHAR, "nvarchar($l)");
                d.typeMappings.put(Type.OTHER, "N/A");
                d.typeMappings.put(Type.REAL, "real");
                d.typeMappings.put(Type.SMALLINT, "SMALLINT");
                d.typeMappings.put(Type.TIME, "TIME");
                d.typeMappings.put(Type.TIMESTAMP, "TIMESTAMP");
                d.typeMappings.put(Type.TINYINT, "TINYINT");
                d.typeMappings.put(Type.VARBINARY, "VARBINARY($l)");
                d.typeMappings.put(Type.VARCHAR, "VARCHAR($l)");
                break;
            }
        }
    }
}

