/*
 * jDialects, a tiny SQL dialect tool 
 *
 * License: GNU Lesser General protected License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package com.github.drinkjava2.jdialects;

/**
 * DDL about features, this file is generated by source code generator (see
 * jDiagen project) from Hibernate5.2.9 final
 * 
 * @author Yong Zhu
 * @since 1.0.2
 */
public class DDLFeatures {

	public static final String NOT_SUPPORT = "NOT_SUPPORT";
	protected String addColumnString;
	protected String addColumnSuffixString;
	protected String addForeignKeyConstraintString;
	protected String addPrimaryKeyConstraintString;
	protected String columnComment;
	protected String createCatalogCommand;
	protected String createMultisetTableString;// for create table without PKEY
	protected String createPooledSequenceStrings;
	protected String createSchemaCommand;
	protected String createSequenceStrings;
	protected String createTableString; // for create table with PKEY
	protected String currentSchemaCommand;
	protected String dropCatalogCommand;
	protected String dropForeignKeyString;
	protected String dropSchemaCommand;
	protected String dropSequenceStrings;
	protected String dropTableString;
	protected Boolean hasAlterTable;
	protected Boolean hasDataTypeInIdentityColumn;
	protected String identityColumnString;
	protected String identityColumnStringBigINT;
	protected String identityInsertString;
	protected String identitySelectString;
	protected Boolean needDropConstraintsBeforeDropTable;
	protected String nullColumnString;// for allowed null column definition
	protected Boolean requiresParensForTupleDistinctCounts;
	protected String selectSequenceNextValString;
	protected String sequenceNextValString;
	protected Boolean supportsColumnCheck;
	protected Boolean supportsCommentOn;
	protected Boolean supportsIdentityColumns;
	protected Boolean supportsIfExistsAfterConstraintName;

	public String getAddColumnString() {
		return addColumnString;
	}

	public String getAddColumnSuffixString() {
		return addColumnSuffixString;
	}

	public String getAddForeignKeyConstraintString() {
		return addForeignKeyConstraintString;
	}

	public String getAddPrimaryKeyConstraintString() {
		return addPrimaryKeyConstraintString;
	}

	public String getColumnComment() {
		return columnComment;
	}

	public String getCreateCatalogCommand() {
		return createCatalogCommand;
	}

	public String getCreateMultisetTableString() {
		return createMultisetTableString;
	}

	public String getCreatePooledSequenceStrings() {
		return createPooledSequenceStrings;
	}

	public String getCreateSchemaCommand() {
		return createSchemaCommand;
	}

	public String getCreateSequenceStrings() {
		return createSequenceStrings;
	}

	public String getCreateTableString() {
		return createTableString;
	}

	public String getCurrentSchemaCommand() {
		return currentSchemaCommand;
	}

	public String getDropCatalogCommand() {
		return dropCatalogCommand;
	}

	public String getDropForeignKeyString() {
		return dropForeignKeyString;
	}

	public String getDropSchemaCommand() {
		return dropSchemaCommand;
	}

	public String getDropSequenceStrings() {
		return dropSequenceStrings;
	}

	public String getDropTableString() {
		return dropTableString;
	}

	public Boolean getHasAlterTable() {
		return hasAlterTable;
	}

	public Boolean getHasDataTypeInIdentityColumn() {
		return hasDataTypeInIdentityColumn;
	}

	public String getIdentityColumnString() {
		return identityColumnString;
	}

	public String getIdentityColumnStringBigINT() {
		return identityColumnStringBigINT;
	}

	public String getIdentityInsertString() {
		return identityInsertString;
	}

	public String getIdentitySelectString() {
		return identitySelectString;
	}

	public Boolean getNeedDropConstraintsBeforeDropTable() {
		return needDropConstraintsBeforeDropTable;
	}

	public String getNullColumnString() {
		return nullColumnString;
	}

	public Boolean getRequiresParensForTupleDistinctCounts() {
		return requiresParensForTupleDistinctCounts;
	}

	public String getSelectSequenceNextValString() {
		return selectSequenceNextValString;
	}

	public String getSequenceNextValString() {
		return sequenceNextValString;
	}

	public Boolean getSupportsColumnCheck() {
		return supportsColumnCheck;
	}

	public Boolean getSupportsCommentOn() {
		return supportsCommentOn;
	}

	public Boolean getSupportsIdentityColumns() {
		return supportsIdentityColumns;
	}

	public Boolean getSupportsIfExistsAfterConstraintName() {
		return supportsIfExistsAfterConstraintName;
	}

	public Boolean getSupportsIfExistsAfterTableName() {
		return supportsIfExistsAfterTableName;
	}

	public Boolean getSupportsIfExistsBeforeConstraintName() {
		return supportsIfExistsBeforeConstraintName;
	}

	public Boolean getSupportsIfExistsBeforeTableName() {
		return supportsIfExistsBeforeTableName;
	}

	public Boolean getSupportsInsertSelectIdentity() {
		return supportsInsertSelectIdentity;
	}

	public Boolean getSupportsPooledSequences() {
		return supportsPooledSequences;
	}

	public Boolean getSupportsSequences() {
		return supportsSequences;
	}

	public Boolean getSupportsTableCheck() {
		return supportsTableCheck;
	}

	public String getTableTypeString() {
		return tableTypeString;
	}

	/**
	 * For dropping a table, can the phrase "if exists" be applied beforeQuery
	 * the table name
	 */
	protected Boolean supportsIfExistsAfterTableName;
	protected Boolean supportsIfExistsBeforeConstraintName;
	/**
	 * For dropping a table, can the phrase "if exists" be applied afterQuery
	 * the table name?
	 */
	protected Boolean supportsIfExistsBeforeTableName;
	protected Boolean supportsInsertSelectIdentity;
	protected Boolean supportsPooledSequences; // support initial & increment
	protected Boolean supportsSequences; // basic sequence
	protected Boolean supportsTableCheck;
	protected String tableTypeString;

	protected static boolean isValidDDLTemplate(String featureValue) {
		if (StrUtils.isEmpty(featureValue) || NOT_SUPPORT.equals(featureValue))
			return false;
		return true;
	}

	public boolean supportBasicOrPooledSequence() {
		return supportsSequences || supportsPooledSequences;
	}

	@SuppressWarnings("all")
	protected static void initDDLFeatures(Dialect dia, DDLFeatures ddl) {
		switch (dia) {
		case SQLiteDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = NOT_SUPPORT;
			ddl.addPrimaryKeyConstraintString = NOT_SUPPORT;
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = false;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "integer";
			ddl.identityColumnStringBigINT = "integer";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_rowid()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case AccessDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case ExcelDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = NOT_SUPPORT;
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case TextDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = NOT_SUPPORT;
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = false;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case ParadoxDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case CobolDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = false;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case XMLDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = NOT_SUPPORT;
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case DbfDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = NOT_SUPPORT;
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case Cache71Dialect: {
			ddl.addColumnString = " add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " ADD CONSTRAINT _FKEYNAME FOREIGN KEY _FKEYNAME (_FK1, _FK2) REFERENCES _REFTABLE (_REF1, _REF2) ";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity";
			ddl.identityColumnStringBigINT = "identity";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "SELECT LAST_IDENTITY() FROM %TSQL_sys.snf";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case CUBRIDDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create serial _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create serial _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop serial _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = "select _SEQNAME.next_value from table({1}) as T(X)";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DataDirectOracle9Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade constraints";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DB2Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "values identity_val_local()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "values nextval for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DB2390Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "select identity_val_local() from sysibm.sysdummy1";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "values nextval for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DB2400Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "select identity_val_local() from sysibm.sysdummy1";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "values nextval for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DerbyDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "values identity_val_local()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DerbyTenFiveDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "values identity_val_local()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DerbyTenSevenDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "values identity_val_local()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "values next value for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case DerbyTenSixDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "values identity_val_local()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "values next value for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case FirebirdDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create generator _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop generator _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "gen_id( _SEQNAME, 1 )";
			ddl.sequenceNextValString = "select gen_id( _SEQNAME, 1 ) from RDB$DATABASE";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case FrontBaseDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case H2Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME if exists";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity";
			ddl.identityColumnStringBigINT = "generated by default as identity";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "call identity()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "call next value for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = true;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case HANAColumnStoreDialect: {
			ddl.addColumnString = "add (";
			ddl.addColumnSuffixString = ")";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE on update cascade";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create column table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create column table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dummy";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case HANARowStoreDialect: {
			ddl.addColumnString = "add (";
			ddl.addColumnSuffixString = ")";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE on update cascade";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dummy";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case HSQLDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ start with 1";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME if exists";
			ddl.dropTableString = "drop table _TABLENAME if exists";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity (start with 1)";
			ddl.identityColumnStringBigINT = "generated by default as identity (start with 1)";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "call identity()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "call next value for _SEQNAME";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case InformixDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint  foreign key (_FK1, _FK2) references _REFTABLE constraint _FKEYNAME";
			ddl.addPrimaryKeyConstraintString = " add constraint primary key constraint _PKEYNAME ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "serial8 not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select dbinfo('sqlca.sqlerrd1') from informix.systables where tabid=1";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from informix.systables where tabid=1";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Informix10Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint  foreign key (_FK1, _FK2) references _REFTABLE constraint _FKEYNAME";
			ddl.addPrimaryKeyConstraintString = " add constraint primary key constraint _PKEYNAME ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "serial8 not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select dbinfo('sqlca.sqlerrd1') from informix.systables where tabid=1";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from informix.systables where tabid=1";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case IngresDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " with null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select nextval for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Ingres10Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null generated by default as identity";
			ddl.identityColumnStringBigINT = "not null generated by default as identity";
			ddl.identityInsertString = "default";
			ddl.identitySelectString = "select last_identity()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " with null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select nextval for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Ingres9Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_identity()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " with null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select nextval for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case InterbaseDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create generator _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "delete from RDB$GENERATORS where RDB$GENERATOR_NAME = '_SEQNAME'";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "gen_id( _SEQNAME, 1 )";
			ddl.sequenceNextValString = "select gen_id( _SEQNAME, 1 ) from RDB$DATABASE";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case JDataStoreDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "autoincrement";
			ddl.identityColumnStringBigINT = "autoincrement";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		case MariaDBDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " engine=InnoDB";
		}
			break;
		case MariaDB53Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " engine=InnoDB";
		}
			break;
		case MckoiDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "nextval('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case MimerSQLDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create unique sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
			ddl.dropTableString = "drop table _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = "select next_value of _SEQNAME from system.onerow";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case MySQLDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " type=MyISAM";
		}
			break;
		case MySQL5Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " engine=MyISAM";
		}
			break;
		case MySQL55Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " engine=InnoDB";
		}
			break;
		case MySQL57Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " engine=InnoDB";
		}
			break;
		case MySQL57InnoDBDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " engine=InnoDB";
		}
			break;
		case MySQL5InnoDBDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " engine=InnoDB";
		}
			break;
		case MySQLInnoDBDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " type=InnoDB";
		}
			break;
		case MySQLMyISAMDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = " comment '_COMMENT'";
			ddl.createCatalogCommand = "create database _CATALOGNAME";
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = NOT_SUPPORT;
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = "drop database _CATALOGNAME";
			ddl.dropForeignKeyString = " drop foreign key ";
			ddl.dropSchemaCommand = NOT_SUPPORT;
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table if exists _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "not null auto_increment";
			ddl.identityColumnStringBigINT = "not null auto_increment";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select last_insert_id()";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " type=MyISAM";
		}
			break;
		case OracleDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade constraints";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Oracle10gDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade constraints";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Oracle12cDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade constraints";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated as identity";
			ddl.identityColumnStringBigINT = "generated as identity";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Oracle8iDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade constraints";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Oracle9Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade constraints";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Oracle9iDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade constraints";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PointbaseDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgresPlusDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQLDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL81Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL82Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL9Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = true;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL91Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = true;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL92Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = true;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL93Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = true;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL94Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = true;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case PostgreSQL95Dialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
			ddl.dropTableString = "drop table if exists _TABLENAME cascade";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = false;
			ddl.identityColumnString = "serial not null";
			ddl.identityColumnStringBigINT = "bigserial not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select currval('_table__col_seq')";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = true;
			ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
			ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = true;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = true;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case ProgressDialect: {
			ddl.addColumnString = "add column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = false;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case RDMSOS2200Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "";
			ddl.dropTableString = "drop table _TABLENAME including contents";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = "select permuted_id('NEXT',31) from rdms.rdms_dummy where key_col = 1 ";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SAPDBDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " foreign key _FKEYNAME (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SQLServerDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SQLServer2005Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SQLServer2008Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SQLServer2012Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "next value for _SEQNAME";
			ddl.sequenceNextValString = "select next value for _SEQNAME";
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = true;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SybaseDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Sybase11Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SybaseAnywhereDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = false;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SybaseASE15Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case SybaseASE157Dialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "identity not null";
			ddl.identityColumnStringBigINT = "identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = "select @@identity";
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = " null";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = true;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = " lock datarows";
		}
			break;
		case TeradataDialect: {
			ddl.addColumnString = "Add Column";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create multiset table ";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case Teradata14Dialect: {
			ddl.addColumnString = "Add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create multiset table ";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = NOT_SUPPORT;
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = NOT_SUPPORT;
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = "generated by default as identity not null";
			ddl.identityColumnStringBigINT = "generated by default as identity not null";
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = NOT_SUPPORT;
			ddl.sequenceNextValString = NOT_SUPPORT;
			ddl.supportsColumnCheck = true;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = true;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = false;
			ddl.supportsTableCheck = true;
			ddl.tableTypeString = "";
		}
			break;
		case TimesTenDialect: {
			ddl.addColumnString = "add";
			ddl.addColumnSuffixString = "";
			ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
			ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
			ddl.columnComment = "";
			ddl.createCatalogCommand = NOT_SUPPORT;
			ddl.createMultisetTableString = "create table";
			ddl.createPooledSequenceStrings = NOT_SUPPORT;
			ddl.createSchemaCommand = "create schema _SCHEMANAME";
			ddl.createSequenceStrings = "create sequence _SEQ";
			ddl.createTableString = "create table";
			ddl.currentSchemaCommand = NOT_SUPPORT;
			ddl.dropCatalogCommand = NOT_SUPPORT;
			ddl.dropForeignKeyString = " drop constraint ";
			ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
			ddl.dropSequenceStrings = "drop sequence _SEQNAME";
			ddl.dropTableString = "drop table _TABLENAME";
			ddl.hasAlterTable = true;
			ddl.hasDataTypeInIdentityColumn = true;
			ddl.identityColumnString = NOT_SUPPORT;
			ddl.identityColumnStringBigINT = NOT_SUPPORT;
			ddl.identityInsertString = NOT_SUPPORT;
			ddl.identitySelectString = NOT_SUPPORT;
			ddl.needDropConstraintsBeforeDropTable = true;
			ddl.nullColumnString = "";
			ddl.requiresParensForTupleDistinctCounts = false;
			ddl.selectSequenceNextValString = "_SEQNAME.nextval";
			ddl.sequenceNextValString = "select first 1 _SEQNAME.nextval from sys.tables";
			ddl.supportsColumnCheck = false;
			ddl.supportsCommentOn = false;
			ddl.supportsIdentityColumns = false;
			ddl.supportsIfExistsAfterConstraintName = false;
			ddl.supportsIfExistsBeforeConstraintName = false;
			ddl.supportsInsertSelectIdentity = false;
			ddl.supportsPooledSequences = false;
			ddl.supportsSequences = true;
			ddl.supportsTableCheck = false;
			ddl.tableTypeString = "";
		}
			break;
		default:
		}
	}

}
