/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.DialectLogger;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.model.AutoIdGen;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyConst;
import com.github.drinkjava2.jdialects.model.IndexConst;
import com.github.drinkjava2.jdialects.model.SequenceGen;
import com.github.drinkjava2.jdialects.model.TableGen;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.model.UniqueConst;
import com.github.drinkjava2.jdialects.utils.StrUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DDLCreateUtils {
    private static DialectLogger logger = DialectLogger.getLog(DDLCreateUtils.class);

    public static String[] toCreateDDL(Dialect dialect, TableModel ... tables) {
        ArrayList<Object> objectResultList = new ArrayList<Object>();
        for (TableModel table : tables) {
            DDLCreateUtils.transferTableToObjectList(dialect, table, objectResultList);
        }
        ArrayList<String> stringResultList = new ArrayList<String>();
        ArrayList<TableGen> tbGeneratorList = new ArrayList<TableGen>();
        ArrayList<SequenceGen> sequenceList = new ArrayList<SequenceGen>();
        ArrayList<AutoIdGen> autoIdGeneratorList = new ArrayList<AutoIdGen>();
        ArrayList<FKeyConst> fKeyConstraintList = new ArrayList<FKeyConst>();
        for (Object e : objectResultList) {
            if (StrUtils.isEmpty(e)) continue;
            if (e instanceof String) {
                stringResultList.add((String)e);
                continue;
            }
            if (e instanceof TableGen) {
                tbGeneratorList.add((TableGen)e);
                continue;
            }
            if (e instanceof SequenceGen) {
                sequenceList.add((SequenceGen)e);
                continue;
            }
            if (e instanceof AutoIdGen) {
                autoIdGeneratorList.add((AutoIdGen)e);
                continue;
            }
            if (!(e instanceof FKeyConst)) continue;
            fKeyConstraintList.add((FKeyConst)e);
        }
        DDLCreateUtils.buildSequenceDDL(dialect, stringResultList, sequenceList);
        DDLCreateUtils.buildTableGeneratorDDL(dialect, stringResultList, tbGeneratorList);
        DDLCreateUtils.buildAutoIdGeneratorDDL(dialect, stringResultList, autoIdGeneratorList);
        DDLCreateUtils.outputFKeyConstraintDDL(dialect, stringResultList, fKeyConstraintList);
        return stringResultList.toArray(new String[stringResultList.size()]);
    }

    private static void transferTableToObjectList(Dialect dialect, TableModel t, List<Object> objectResultList) {
        List<UniqueConst> l2;
        DDLFeatures features = dialect.ddlFeatures;
        StringBuilder buf = new StringBuilder();
        boolean hasPkey = false;
        String pkeys = "";
        String tableName = t.getTableName();
        Map<String, ColumnModel> columns = t.getColumns();
        dialect.checkNotEmptyReservedWords(tableName, "Table name can not be empty");
        List<IndexConst> l = t.getIndexConsts();
        if (l != null && !l.isEmpty()) {
            for (IndexConst index : l) {
                dialect.checkReservedWords(index.getName());
            }
        }
        if ((l2 = t.getUniqueConsts()) != null && !l2.isEmpty()) {
            for (UniqueConst unique : l2) {
                dialect.checkReservedWords(unique.getName());
            }
        }
        for (ColumnModel col : columns.values()) {
            dialect.checkNotEmptyReservedWords(col.getColumnName(), "Column name can not be empty");
        }
        for (ColumnModel col : columns.values()) {
            if (!col.getAutoGenerator().booleanValue()) continue;
            if (features.supportBasicOrPooledSequence()) {
                objectResultList.add(new SequenceGen("jdialects_autoid", "jdialects_autoid", 1, 1));
                continue;
            }
            objectResultList.add(new AutoIdGen());
        }
        for (SequenceGen seq : t.getSequences().values()) {
            objectResultList.add(seq);
        }
        for (TableGen tableGenerator : t.getTableGenerators().values()) {
            objectResultList.add(tableGenerator);
        }
        for (FKeyConst fkey : t.getFkeyConstraints()) {
            objectResultList.add(fkey);
        }
        for (ColumnModel col : columns.values()) {
            if (!col.getPkey().booleanValue()) continue;
            hasPkey = true;
            if (StrUtils.isEmpty(pkeys)) {
                pkeys = col.getColumnName();
                continue;
            }
            pkeys = pkeys + "," + col.getColumnName();
        }
        buf.append(hasPkey ? dialect.ddlFeatures.createTableString : dialect.ddlFeatures.createMultisetTableString).append(" ").append(tableName).append(" ( ");
        for (ColumnModel c : columns.values()) {
            if (c.getColumnType() == null) {
                DialectException.throwEX("Type not set on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\"");
            }
            buf.append(c.getColumnName()).append(" ");
            if (c.getIdentity().booleanValue() && !features.supportsIdentityColumns.booleanValue()) {
                DialectException.throwEX("Unsupported identity setting for dialect \"" + (Object)((Object)dialect) + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\"");
            }
            if (c.getIdentity().booleanValue()) {
                if (features.hasDataTypeInIdentityColumn.booleanValue()) {
                    buf.append(dialect.translateToDDLType(c.getColumnType(), c.getLengths()));
                }
                buf.append(' ');
                if (Type.BIGINT.equals((Object)c.getColumnType())) {
                    buf.append(features.identityColumnStringBigINT);
                } else {
                    buf.append(features.identityColumnString);
                }
            } else {
                buf.append(dialect.translateToDDLType(c.getColumnType(), c.getLengths()));
                String defaultValue = c.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (!c.getNullable().booleanValue()) {
                    buf.append(" not null");
                } else {
                    buf.append(features.nullColumnString);
                }
            }
            if (!StrUtils.isEmpty(c.getCheck())) {
                if (features.supportsColumnCheck.booleanValue()) {
                    buf.append(" check (").append(c.getCheck()).append(")");
                } else {
                    logger.warn("Ignore unsupported check setting for dialect \"" + (Object)((Object)dialect) + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\" with value: " + c.getCheck());
                }
            }
            if (c.getComment() != null) {
                if (StrUtils.isEmpty(features.columnComment) && !features.supportsCommentOn.booleanValue()) {
                    logger.warn("Ignore unsupported comment setting for dialect \"" + (Object)((Object)dialect) + "\" on column \"" + c.getColumnName() + "\" at table \"" + tableName + "\" with value: " + c.getComment());
                } else {
                    buf.append(StrUtils.replace(features.columnComment, "_COMMENT", c.getComment()));
                }
            }
            if (!StrUtils.isEmpty(c.getTail())) {
                buf.append(c.getTail());
            }
            buf.append(",");
        }
        if (!StrUtils.isEmpty(pkeys)) {
            buf.append(" primary key (").append(pkeys).append("),");
        }
        if (!StrUtils.isEmpty(t.getCheck())) {
            if (features.supportsTableCheck.booleanValue()) {
                buf.append(" check (").append(t.getCheck()).append("),");
            } else {
                logger.warn("Ignore unsupported table check setting for dialect \"" + (Object)((Object)dialect) + "\" on table \"" + tableName + "\" with value: " + t.getCheck());
            }
        }
        buf.setLength(buf.length() - 1);
        buf.append(")");
        String tableTypeString = features.tableTypeString;
        if (!StrUtils.isEmpty(tableTypeString) && !"NOT_SUPPORT".equals(tableTypeString)) {
            buf.append(tableTypeString);
            if (!StrUtils.isEmpty(t.getEngineTail())) {
                buf.append(t.getEngineTail());
            }
        }
        objectResultList.add(buf.toString());
        if (t.getComment() != null) {
            if (features.supportsCommentOn.booleanValue()) {
                objectResultList.add("comment on table " + t.getTableName() + " is '" + t.getComment() + "'");
            } else {
                logger.warn("Ignore unsupported table comment setting for dialect \"" + (Object)((Object)dialect) + "\" on table \"" + tableName + "\" with value: " + t.getComment());
            }
        }
        for (ColumnModel c : columns.values()) {
            if (!features.supportsCommentOn.booleanValue() || c.getComment() == null || !StrUtils.isEmpty(features.columnComment)) continue;
            objectResultList.add("comment on column " + tableName + '.' + c.getColumnName() + " is '" + c.getComment() + "'");
        }
        DDLCreateUtils.buildIndexDLL(dialect, objectResultList, t);
        DDLCreateUtils.buildUniqueDLL(dialect, objectResultList, t);
    }

    private static void buildSequenceDDL(Dialect dialect, List<String> stringList, List<SequenceGen> sequenceList) {
        DDLFeatures features = dialect.ddlFeatures;
        for (SequenceGen seq : sequenceList) {
            DialectException.assureNotEmpty(seq.getName(), "SequenceGen name can not be empty");
            DialectException.assureNotEmpty(seq.getSequenceName(), "sequenceName can not be empty of \"" + seq.getName() + "\"");
        }
        for (SequenceGen seq : sequenceList) {
            for (SequenceGen seq2 : sequenceList) {
                if (seq == seq2 || seq2.getAllocationSize() == 0) continue;
                if (seq.getName().equalsIgnoreCase(seq2.getName())) {
                    seq.setAllocationSize(0);
                    continue;
                }
                if (!seq.getSequenceName().equalsIgnoreCase(seq2.getSequenceName())) continue;
                DialectException.throwEX("Dulplicated SequenceGen setting \"" + seq.getName() + "\" and \"" + seq2.getName() + "\" found.");
            }
        }
        HashSet<String> sequenceNameExisted = new HashSet<String>();
        for (SequenceGen seq : sequenceList) {
            String sequenceName;
            if (seq.getAllocationSize() == 0 || sequenceNameExisted.contains(sequenceName = seq.getSequenceName().toLowerCase())) continue;
            if (!features.supportBasicOrPooledSequence()) {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support sequence setting on sequence \"" + seq.getName() + "\"");
            }
            if (features.supportsPooledSequences.booleanValue()) {
                String pooledSequence = StrUtils.replace(features.createPooledSequenceStrings, "_SEQ", seq.getSequenceName());
                pooledSequence = StrUtils.replace(pooledSequence, "11", "" + seq.getInitialValue());
                pooledSequence = StrUtils.replace(pooledSequence, "33", "" + seq.getAllocationSize());
                stringList.add(pooledSequence);
            } else {
                if (seq.getInitialValue() >= 2 || seq.getAllocationSize() >= 2) {
                    DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support initialValue and allocationSize setting on sequence \"" + seq.getName() + "\", try set initialValue and allocationSize to 1 to fix");
                }
                String simepleSeq = StrUtils.replace(features.createSequenceStrings, "_SEQ", seq.getSequenceName());
                stringList.add(simepleSeq);
            }
            sequenceNameExisted.add(sequenceName);
        }
    }

    private static void buildAutoIdGeneratorDDL(Dialect dialect, List<String> stringList, List<AutoIdGen> autoIdGenerator) {
        if (autoIdGenerator != null && !autoIdGenerator.isEmpty()) {
            stringList.add(dialect.ddlFeatures.createTableString + " " + "jdialects_autoid" + " (" + "next_val" + " " + dialect.translateToDDLType(Type.BIGINT, new Integer[0]) + " )");
            stringList.add("insert into jdialects_autoid values ( 1 )");
        }
    }

    private static void buildTableGeneratorDDL(Dialect dialect, List<String> stringList, List<TableGen> tbGeneratorList) {
        for (TableGen tg : tbGeneratorList) {
            DialectException.assureNotEmpty(tg.getName(), "TableGen name can not be empty");
            DialectException.assureNotEmpty(tg.getTableName(), "TableGen tableName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnName(), "TableGen pkColumnName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnValue(), "TableGen pkColumnValue can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getValueColumnName(), "TableGen valueColumnName can not be empty of \"" + tg.getName() + "\"");
        }
        for (TableGen tg : tbGeneratorList) {
            for (TableGen tg2 : tbGeneratorList) {
                if (tg == tg2 || tg2.getAllocationSize() == 0) continue;
                if (tg.getName().equalsIgnoreCase(tg2.getName())) {
                    tg.setAllocationSize(0);
                    continue;
                }
                if (!tg.getTableName().equalsIgnoreCase(tg2.getTableName()) || !tg.getPkColumnName().equalsIgnoreCase(tg2.getPkColumnName()) || !tg.getPkColumnValue().equalsIgnoreCase(tg2.getPkColumnValue()) || !tg.getValueColumnName().equalsIgnoreCase(tg2.getValueColumnName())) continue;
                DialectException.throwEX("Dulplicated tableGenerator setting \"" + tg.getName() + "\" and \"" + tg2.getName() + "\" found.");
            }
        }
        HashSet<String> tableExisted = new HashSet<String>();
        HashSet<String> columnExisted = new HashSet<String>();
        for (TableGen tg : tbGeneratorList) {
            if (tg.getAllocationSize() == 0) continue;
            String tableName = tg.getTableName().toLowerCase();
            String tableAndPKColumn = tg.getTableName().toLowerCase() + "..XXOO.." + tg.getPkColumnName();
            String tableAndValColumn = tg.getTableName().toLowerCase() + "..XXOO.." + tg.getValueColumnName();
            if (!tableExisted.contains(tableName)) {
                String s = dialect.ddlFeatures.createTableString + " " + tableName + " (";
                s = s + tg.getPkColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + ",";
                s = s + tg.getValueColumnName() + " " + dialect.translateToDDLType(Type.BIGINT, new Integer[0]) + " )";
                stringList.add(s);
                tableExisted.add(tableName);
                columnExisted.add(tableAndPKColumn);
                columnExisted.add(tableAndValColumn);
                continue;
            }
            if (!columnExisted.contains(tableAndPKColumn)) {
                stringList.add("alter table " + tableName + " " + dialect.ddlFeatures.addColumnString + " " + tg.getPkColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + " " + dialect.ddlFeatures.addColumnSuffixString);
                columnExisted.add(tableAndPKColumn);
            }
            if (columnExisted.contains(tableAndValColumn)) continue;
            stringList.add("alter table " + tableName + " " + dialect.ddlFeatures.addColumnString + " " + tg.getValueColumnName() + " " + dialect.translateToDDLType(Type.VARCHAR, 100) + " " + dialect.ddlFeatures.addColumnSuffixString);
            columnExisted.add(tableAndValColumn);
        }
    }

    private static void outputFKeyConstraintDDL(Dialect dialect, List<String> stringList, List<FKeyConst> trueList) {
        if ("NOT_SUPPORT".equals(dialect.ddlFeatures.addForeignKeyConstraintString)) {
            logger.warn("Dialect \"" + (Object)((Object)dialect) + "\" does not support foreign key setting, settings be ignored");
            return;
        }
        for (FKeyConst t : trueList) {
            String constName = t.getFkeyName();
            if (StrUtils.isEmpty(constName)) {
                constName = "fk_" + t.getTableName().toLowerCase() + "_" + StrUtils.replace(StrUtils.listToString(t.getColumnNames()), ",", "_");
            }
            String s = dialect.ddlFeatures.addForeignKeyConstraintString;
            s = StrUtils.replace(s, "_FK1, _FK2", StrUtils.listToString(t.getColumnNames()));
            s = StrUtils.replace(s, "_REF1, _REF2", StrUtils.arrayToStringButSkipFirst(t.getRefTableAndColumns()));
            s = StrUtils.replace(s, "_REFTABLE", t.getRefTableAndColumns()[0]);
            s = StrUtils.replace(s, "_FKEYNAME", constName);
            String tail = StrUtils.isEmpty(t.getFkeyTail()) ? "" : " " + t.getFkeyTail();
            stringList.add("alter table " + t.getTableName() + " " + s + tail);
        }
    }

    private static void buildIndexDLL(Dialect dialect, List<Object> objectResultList, TableModel t) {
        List<IndexConst> l = t.getIndexConsts();
        if (l == null || l.isEmpty()) {
            return;
        }
        String template = Dialect.Teradata14Dialect.equals((Object)dialect) ? "create $ifUnique index $indexName ($indexValues) on " + t.getTableName() : "create $ifUnique index $indexName on " + t.getTableName() + " ($indexValues)";
        for (IndexConst index : l) {
            String indexname = index.getName();
            if (StrUtils.isEmpty(indexname)) {
                indexname = "IX_" + t.getTableName() + "_" + StrUtils.arrayToString(index.getColumnList(), "_");
            }
            String ifUnique = index.getUnique() != false ? "unique" : "";
            String result = StrUtils.replace(template, "$ifUnique", ifUnique);
            result = StrUtils.replace(result, "$indexName", indexname);
            result = StrUtils.replace(result, "$indexValues", StrUtils.arrayToString(index.getColumnList()));
            objectResultList.add(result);
        }
    }

    private static void buildUniqueDLL(Dialect dialect, List<Object> objectResultList, TableModel t) {
        List<UniqueConst> l = t.getUniqueConsts();
        if (l == null || l.isEmpty()) {
            return;
        }
        String dialectName = "" + (Object)((Object)dialect);
        for (UniqueConst unique : l) {
            String[] columns;
            boolean nullable = false;
            for (String colNames : columns = unique.getColumnList()) {
                ColumnModel vc = t.getColumn(colNames.toLowerCase());
                if (vc == null || !vc.getNullable().booleanValue()) continue;
                nullable = true;
            }
            String uniqueName = unique.getName();
            if (StrUtils.isEmpty(uniqueName)) {
                uniqueName = "UK_" + t.getTableName() + "_" + StrUtils.arrayToString(unique.getColumnList(), "_");
            }
            String template = "alter table $TABLE add constraint $UKNAME unique ($COLUMNS)";
            if ((StrUtils.startsWithIgnoreCase(dialectName, "DB2") || StrUtils.startsWithIgnoreCase(dialectName, "DERBY")) && nullable) {
                template = "create unique index $UKNAME on $TABLE ($COLUMNS)";
            } else if (StrUtils.startsWithIgnoreCase(dialectName, "Informix")) {
                template = "alter table $TABLE add constraint unique ($COLUMNS) constraint $UKNAME";
            }
            String result = StrUtils.replace(template, "$TABLE", t.getTableName());
            result = StrUtils.replace(result, "$UKNAME", uniqueName);
            result = StrUtils.replace(result, "$COLUMNS", StrUtils.arrayToString(unique.getColumnList()));
            objectResultList.add(result);
        }
    }
}

