/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.model.AutoIdGen;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyConst;
import com.github.drinkjava2.jdialects.model.IndexConst;
import com.github.drinkjava2.jdialects.model.SequenceGen;
import com.github.drinkjava2.jdialects.model.TableGen;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.model.UniqueConst;
import com.github.drinkjava2.jdialects.utils.StrUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DDLDropUtils {
    public static String[] toDropDDL(Dialect dialect, TableModel ... tables) {
        ArrayList<Object> objectResultList = new ArrayList<Object>();
        for (TableModel table : tables) {
            DDLDropUtils.transferTableToObjectList(dialect, table, objectResultList);
        }
        ArrayList<String> stringResultList = new ArrayList<String>();
        ArrayList<TableGen> tbGeneratorList = new ArrayList<TableGen>();
        ArrayList<SequenceGen> sequenceList = new ArrayList<SequenceGen>();
        ArrayList<AutoIdGen> globalIdGeneratorList = new ArrayList<AutoIdGen>();
        ArrayList<FKeyConst> fKeyConstraintList = new ArrayList<FKeyConst>();
        for (Object e : objectResultList) {
            if (StrUtils.isEmpty(e)) continue;
            if (e instanceof String) {
                stringResultList.add((String)e);
                continue;
            }
            if (e instanceof TableGen) {
                tbGeneratorList.add((TableGen)e);
                continue;
            }
            if (e instanceof SequenceGen) {
                sequenceList.add((SequenceGen)e);
                continue;
            }
            if (e instanceof AutoIdGen) {
                globalIdGeneratorList.add((AutoIdGen)e);
                continue;
            }
            if (!(e instanceof FKeyConst)) continue;
            fKeyConstraintList.add((FKeyConst)e);
        }
        DDLDropUtils.buildDropSequenceDDL(dialect, stringResultList, sequenceList);
        DDLDropUtils.buildDropTableGeneratorDDL(dialect, stringResultList, tbGeneratorList);
        DDLDropUtils.buildDropGolbalIDGeneratorDDL(dialect, stringResultList, globalIdGeneratorList);
        DDLDropUtils.outputDropFKeyConstraintDDL(dialect, stringResultList, fKeyConstraintList);
        return stringResultList.toArray(new String[stringResultList.size()]);
    }

    private static void transferTableToObjectList(Dialect dialect, TableModel t, List<Object> objectResultList) {
        List<UniqueConst> l2;
        DDLFeatures features = dialect.ddlFeatures;
        StringBuilder buf = new StringBuilder();
        String tableName = t.getTableName();
        Map<String, ColumnModel> columns = t.getColumns();
        dialect.checkNotEmptyReservedWords(tableName, "Table name can not be empty");
        List<IndexConst> l = t.getIndexConsts();
        if (l != null && !l.isEmpty()) {
            for (IndexConst index : l) {
                dialect.checkReservedWords(index.getName());
            }
        }
        if ((l2 = t.getUniqueConsts()) != null && !l2.isEmpty()) {
            for (UniqueConst unique : l2) {
                dialect.checkReservedWords(unique.getName());
            }
        }
        for (ColumnModel col : columns.values()) {
            dialect.checkNotEmptyReservedWords(col.getColumnName(), "Column name can not be empty");
        }
        for (ColumnModel col : columns.values()) {
            if (!col.getAutoGenerator().booleanValue()) continue;
            if (features.supportBasicOrPooledSequence()) {
                objectResultList.add(new SequenceGen("jdialects_autoid", "jdialects_autoid", 1, 1));
                continue;
            }
            objectResultList.add(new AutoIdGen());
        }
        for (SequenceGen seq : t.getSequences().values()) {
            objectResultList.add(seq);
        }
        for (TableGen tableGenerator : t.getTableGenerators().values()) {
            objectResultList.add(tableGenerator);
        }
        for (FKeyConst fkey : t.getFkeyConstraints()) {
            objectResultList.add(fkey);
        }
        buf.append(dialect.dropTableDDL(tableName));
        objectResultList.add(buf.toString());
    }

    private static void buildDropSequenceDDL(Dialect dialect, List<String> stringResultList, List<SequenceGen> sequenceList) {
        DDLFeatures features = dialect.ddlFeatures;
        for (SequenceGen seq : sequenceList) {
            DialectException.assureNotEmpty(seq.getName(), "SequenceGen name can not be empty");
            DialectException.assureNotEmpty(seq.getSequenceName(), "sequenceName can not be empty of \"" + seq.getName() + "\"");
        }
        for (SequenceGen seq : sequenceList) {
            for (SequenceGen seq2 : sequenceList) {
                if (seq == seq2 || seq2.getAllocationSize() == 0) continue;
                if (seq.getName().equalsIgnoreCase(seq2.getName())) {
                    seq.setAllocationSize(0);
                    continue;
                }
                if (!seq.getSequenceName().equalsIgnoreCase(seq2.getSequenceName())) continue;
                DialectException.throwEX("Dulplicated SequenceGen setting \"" + seq.getName() + "\" and \"" + seq2.getName() + "\" found.");
            }
        }
        HashSet<String> sequenceNameExisted = new HashSet<String>();
        for (SequenceGen seq : sequenceList) {
            String sequenceName;
            if (seq.getAllocationSize() == 0 || sequenceNameExisted.contains(sequenceName = seq.getSequenceName().toLowerCase())) continue;
            if (!features.supportBasicOrPooledSequence()) {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support sequence setting on sequence \"" + seq.getName() + "\"");
            }
            if (!"NOT_SUPPORT".equals(features.dropSequenceStrings) && !StrUtils.isEmpty(features.dropSequenceStrings)) {
                stringResultList.add(0, StrUtils.replace(features.dropSequenceStrings, "_SEQNAME", seq.getSequenceName()));
            } else {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support drop sequence ddl, on sequence \"" + seq.getName() + "\"");
            }
            sequenceNameExisted.add(sequenceName);
        }
    }

    private static void buildDropTableGeneratorDDL(Dialect dialect, List<String> stringResultList, List<TableGen> tbGeneratorList) {
        for (TableGen tg : tbGeneratorList) {
            DialectException.assureNotEmpty(tg.getName(), "TableGen name can not be empty");
            DialectException.assureNotEmpty(tg.getTableName(), "TableGen tableName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnName(), "TableGen pkColumnName can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getPkColumnValue(), "TableGen pkColumnValue can not be empty of \"" + tg.getName() + "\"");
            DialectException.assureNotEmpty(tg.getValueColumnName(), "TableGen valueColumnName can not be empty of \"" + tg.getName() + "\"");
        }
        HashSet<String> tableExisted = new HashSet<String>();
        for (TableGen tg : tbGeneratorList) {
            String tableName = tg.getTableName().toLowerCase();
            if (tableExisted.contains(tableName)) continue;
            stringResultList.add(0, dialect.dropTableDDL(tableName));
            tableExisted.add(tableName);
        }
    }

    private static void buildDropGolbalIDGeneratorDDL(Dialect dialect, List<String> stringResultList, List<AutoIdGen> globalIdGeneratorList) {
        if (globalIdGeneratorList != null && !globalIdGeneratorList.isEmpty()) {
            stringResultList.add(0, dialect.dropTableDDL("jdialects_autoid"));
        }
    }

    private static void outputDropFKeyConstraintDDL(Dialect dialect, List<String> stringResultList, List<FKeyConst> trueList) {
        if ("NOT_SUPPORT".equals(dialect.ddlFeatures.addForeignKeyConstraintString)) {
            return;
        }
        for (FKeyConst t : trueList) {
            String dropStr = dialect.ddlFeatures.dropForeignKeyString;
            String constName = t.getFkeyName();
            if (StrUtils.isEmpty(constName)) {
                constName = "fk_" + t.getTableName().toLowerCase() + "_" + StrUtils.replace(StrUtils.listToString(t.getColumnNames()), ",", "_");
            }
            if ("NOT_SUPPORT".equals(dropStr)) {
                DialectException.throwEX("Dialect \"" + (Object)((Object)dialect) + "\" does not support drop foreign key, for setting: \"" + "fk_" + constName + "\"");
            }
            stringResultList.add(0, "alter table " + t.getTableName() + " " + dropStr + " " + constName);
        }
    }
}

