/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DialectJdbcUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long hotExecuteQuery(Connection conn, String sql) throws SQLException {
        Long l;
        PreparedStatement pst = null;
        SQLException exception = null;
        ResultSet rs = null;
        try {
            pst = conn.prepareStatement(sql);
            rs = pst.executeQuery();
            rs.next();
            l = rs.getLong(1);
        }
        catch (SQLException e) {
            Long l2;
            try {
                exception = e;
                l2 = null;
            }
            catch (Throwable throwable) {
                DialectJdbcUtils.closeRSandPST(rs, pst, exception);
                throw throwable;
            }
            DialectJdbcUtils.closeRSandPST(rs, pst, exception);
            return l2;
        }
        DialectJdbcUtils.closeRSandPST(rs, pst, exception);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hotExecuteUpdate(Connection conn, String sql) throws SQLException {
        PreparedStatement pst = null;
        SQLException exception = null;
        try {
            pst = conn.prepareStatement(sql);
            int n = pst.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            exception = e;
            int n = 0;
            return n;
        }
        finally {
            DialectJdbcUtils.closeRSandPST(null, pst, exception);
        }
    }

    public static void closeRSandPST(ResultSet rs, PreparedStatement pst, SQLException exception) throws SQLException {
        SQLException newSQLException = exception;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                if (newSQLException != null) {
                    e.setNextException(newSQLException);
                }
                newSQLException = e;
            }
        }
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                if (newSQLException != null) {
                    e.setNextException(newSQLException);
                }
                newSQLException = e;
            }
        }
        if (newSQLException != null) {
            throw newSQLException;
        }
    }
}

