/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.model.FKeyConst;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.utils.StrUtils;

public class ColumnModel {
    private String columnName;
    private TableModel tableModel;
    private Type columnType;
    private Boolean pkey = false;
    private Boolean nullable = true;
    private Boolean identity = false;
    private String check;
    private String defaultValue;
    private String sequence;
    private String tableGenerator;
    private String tail;
    private Boolean autoGenerator = false;
    private String comment;
    private Integer[] lengths = new Integer[0];
    private String pojoField;
    private Integer length = 255;
    private Integer precision = 0;
    private Integer scale = 0;
    private Boolean insertable = true;
    private Boolean updatable = true;

    public ColumnModel(String columnName) {
        if (StrUtils.isEmpty(columnName)) {
            DialectException.throwEX("columnName is not allowed empty");
        }
        this.columnName = columnName;
    }

    public ColumnModel notNull() {
        this.nullable = false;
        return this;
    }

    public ColumnModel check(String check) {
        this.check = check;
        return this;
    }

    public ColumnModel singleIndex(String indexName) {
        DialectException.assureNotNull(this.tableModel, "index() shortcut method used only as tableModel.column().index() format");
        DialectException.assureNotEmpty(indexName, "indexName can not be empty");
        this.tableModel.index(indexName).columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleIndex() {
        DialectException.assureNotNull(this.tableModel, "index() shortcut method used only as tableModel.column().index() format");
        this.tableModel.index().columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleUnique(String uniqueName) {
        DialectException.assureNotNull(this.tableModel, "unique() shortcut method used only as tableModel.column().index() format");
        DialectException.assureNotEmpty(uniqueName, "indexName can not be empty");
        this.tableModel.unique(uniqueName).columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleUnique() {
        DialectException.assureNotNull(this.tableModel, "unique() shortcut method used only as tableModel.column().index() format");
        this.tableModel.unique().columns(this.getColumnName());
        return this;
    }

    public ColumnModel identity() {
        this.identity = true;
        return this;
    }

    public ColumnModel defaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public ColumnModel comment(String comment) {
        this.comment = comment;
        return this;
    }

    public ColumnModel pkey() {
        this.pkey = true;
        return this;
    }

    public FKeyConst singleFKey(String ... refTableAndColumns) {
        DialectException.assureNotNull(this.tableModel, "singleFKey() method only be used when tableModel is set, like tableModel.column().singleFKey() format");
        if (refTableAndColumns == null || refTableAndColumns.length != 2) {
            throw new DialectException("singleFKey() method can only have 2 parameters like \"tablename\",\"col1\"");
        }
        return this.tableModel.fkey().columns(this.columnName).refs(refTableAndColumns);
    }

    public ColumnModel sequence(String sequence) {
        this.sequence = sequence;
        return this;
    }

    public ColumnModel tableGenerator(String tableGenerator) {
        this.tableGenerator = tableGenerator;
        return this;
    }

    public ColumnModel autoID() {
        this.autoGenerator = true;
        return this;
    }

    public ColumnModel tail(String tail) {
        this.tail = tail;
        return this;
    }

    public ColumnModel pojoField(String pojoField) {
        this.pojoField = pojoField;
        return this;
    }

    public ColumnModel insertable(Boolean insertable) {
        this.insertable = insertable;
        return this;
    }

    public ColumnModel updatable(Boolean updatable) {
        this.updatable = updatable;
        return this;
    }

    public ColumnModel LONG() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public ColumnModel BOOLEAN() {
        this.columnType = Type.BOOLEAN;
        return this;
    }

    public ColumnModel DOUBLE() {
        this.columnType = Type.DOUBLE;
        return this;
    }

    public ColumnModel FLOAT(Integer ... lengths) {
        this.columnType = Type.FLOAT;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel INTEGER() {
        this.columnType = Type.INTEGER;
        return this;
    }

    public ColumnModel SHORT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public ColumnModel BIGDECIMAL(Integer precision, Integer scale) {
        this.columnType = Type.NUMERIC;
        this.lengths = new Integer[]{precision, scale};
        return this;
    }

    public ColumnModel STRING(Integer length) {
        this.columnType = Type.VARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel DATE() {
        this.columnType = Type.DATE;
        return this;
    }

    public ColumnModel TIME() {
        this.columnType = Type.TIME;
        return this;
    }

    public ColumnModel TIMESTAMP() {
        this.columnType = Type.TIMESTAMP;
        return this;
    }

    public ColumnModel BIGINT() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public ColumnModel BINARY(Integer ... lengths) {
        this.columnType = Type.BINARY;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel BIT() {
        this.columnType = Type.BIT;
        return this;
    }

    public ColumnModel BLOB(Integer ... lengths) {
        this.columnType = Type.BLOB;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel CHAR(Integer ... lengths) {
        this.columnType = Type.CHAR;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel CLOB(Integer ... lengths) {
        this.columnType = Type.CLOB;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel DECIMAL(Integer ... lengths) {
        this.columnType = Type.DECIMAL;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel JAVA_OBJECT() {
        this.columnType = Type.JAVA_OBJECT;
        return this;
    }

    public ColumnModel LONGNVARCHAR(Integer length) {
        this.columnType = Type.LONGNVARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel LONGVARBINARY(Integer ... lengths) {
        this.columnType = Type.LONGVARBINARY;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel LONGVARCHAR(Integer ... lengths) {
        this.columnType = Type.LONGVARCHAR;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel NCHAR(Integer length) {
        this.columnType = Type.NCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel NCLOB() {
        this.columnType = Type.NCLOB;
        return this;
    }

    public ColumnModel NUMERIC(Integer ... lengths) {
        this.columnType = Type.NUMERIC;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel NVARCHAR(Integer length) {
        this.columnType = Type.NVARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public ColumnModel OTHER(Integer ... lengths) {
        this.columnType = Type.OTHER;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel REAL() {
        this.columnType = Type.REAL;
        return this;
    }

    public ColumnModel SMALLINT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public ColumnModel TINYINT() {
        this.columnType = Type.TINYINT;
        return this;
    }

    public ColumnModel VARBINARY(Integer ... lengths) {
        this.columnType = Type.VARBINARY;
        this.lengths = lengths;
        return this;
    }

    public ColumnModel VARCHAR(Integer length) {
        this.columnType = Type.VARCHAR;
        this.lengths = new Integer[]{length};
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public Type getColumnType() {
        return this.columnType;
    }

    public void setColumnType(Type columnType) {
        this.columnType = columnType;
    }

    public Boolean getPkey() {
        return this.pkey;
    }

    public void setPkey(Boolean pkey) {
        this.pkey = pkey;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public Boolean getIdentity() {
        return this.identity;
    }

    public void setIdentity(Boolean identity) {
        this.identity = identity;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getTableGenerator() {
        return this.tableGenerator;
    }

    public void setTableGenerator(String tableGenerator) {
        this.tableGenerator = tableGenerator;
    }

    public String getTail() {
        return this.tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public Boolean getAutoGenerator() {
        return this.autoGenerator;
    }

    public void setAutoGenerator(Boolean autoGenerator) {
        this.autoGenerator = autoGenerator;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer[] getLengths() {
        return this.lengths;
    }

    public void setLengths(Integer[] lengths) {
        this.lengths = lengths;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Boolean getInsertable() {
        return this.insertable;
    }

    public void setInsertable(Boolean insertable) {
        this.insertable = insertable;
    }

    public Boolean getUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(Boolean updatable) {
        this.updatable = updatable;
    }

    public String getPojoField() {
        return this.pojoField;
    }

    public void setPojoField(String pojoField) {
        this.pojoField = pojoField;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }
}

