/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.springsrc.utils.ReflectionUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ModelUtilsOfEntity {
    private static Map<Class<?>, TableModel> tableModelCache = new ConcurrentHashMap();

    private static boolean matchNameCheck(String annotationName, String cName) {
        if (("javax.persistence." + annotationName).equals(cName)) {
            return true;
        }
        if (("com.github.drinkjava2.jdialects.annotation.jpa." + annotationName).equals(cName)) {
            return true;
        }
        if (("com.github.drinkjava2.jdialects.annotation.jdia." + annotationName).equals(cName)) {
            return true;
        }
        if (("com.github.drinkjava2.jdialects.annotation.jdia." + annotationName + "1").equals(cName)) {
            return true;
        }
        if (("com.github.drinkjava2.jdialects.annotation.jdia." + annotationName + "2").equals(cName)) {
            return true;
        }
        return ("com.github.drinkjava2.jdialects.annotation.jdia." + annotationName + "3").equals(cName);
    }

    private static List<Map<String, Object>> getEntityAnnos(Object targetClass, String annotationName) {
        Annotation[] anno = null;
        anno = targetClass instanceof Field ? ((Field)targetClass).getAnnotations() : ((Class)targetClass).getAnnotations();
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Annotation annotation : anno) {
            Class<? extends Annotation> type = annotation.annotationType();
            String cName = type.getName();
            if (!ModelUtilsOfEntity.matchNameCheck(annotationName, cName)) continue;
            l.add(ModelUtilsOfEntity.changeAnnotationValuesToMap(annotation, type));
        }
        return l;
    }

    private static Map<String, Object> getFirstEntityAnno(Object targetClass, String annotationName) {
        Annotation[] anno = null;
        anno = targetClass instanceof Field ? ((Field)targetClass).getAnnotations() : ((Class)targetClass).getAnnotations();
        for (Annotation annotation : anno) {
            Class<? extends Annotation> type = annotation.annotationType();
            String cName = type.getName();
            if (!ModelUtilsOfEntity.matchNameCheck(annotationName, cName)) continue;
            return ModelUtilsOfEntity.changeAnnotationValuesToMap(annotation, type);
        }
        return new HashMap<String, Object>();
    }

    private static boolean existEntityAnno(Object targetClass, String annotationName) {
        Map<String, Object> annotion = ModelUtilsOfEntity.getFirstEntityAnno(targetClass, annotationName);
        return annotion.size() == 1;
    }

    private static Map<String, Object> changeAnnotationValuesToMap(Annotation annotation, Class<? extends Annotation> type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("AnnotationExist", true);
        for (Method method : type.getDeclaredMethods()) {
            try {
                result.put(method.getName(), method.invoke((Object)annotation, (Object[])null));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static TableModel[] entity2Model(Class<?> ... entityClasses) {
        ArrayList<TableModel> l = new ArrayList<TableModel>();
        for (Class<?> clazz : entityClasses) {
            l.add(ModelUtilsOfEntity.oneEntity2Model(clazz));
        }
        return l.toArray(new TableModel[l.size()]);
    }

    public static TableModel oneEntity2Model(Class<?> entityClass) {
        DialectException.assureNotNull(entityClass, "Entity class can not be null");
        TableModel model = tableModelCache.get(entityClass);
        if (model != null) {
            return model.newCopy();
        }
        model = ModelUtilsOfEntity.entity2ModelIgnoreConfigMethod(entityClass);
        Method method = null;
        try {
            method = entityClass.getMethod("config", TableModel.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (method != null) {
            try {
                method.invoke(null, model);
            }
            catch (Exception e) {
                throw new DialectException(e);
            }
        }
        if (model != null) {
            tableModelCache.put(entityClass, model);
        }
        return model.newCopy();
    }

    private static TableModel entity2ModelIgnoreConfigMethod(Class<?> entityClass) {
        Map<String, Object> uuidAnyMp;
        Map<String, Object> tableGenMap;
        Map<String, Object> seqMap;
        DialectException.assureNotNull(entityClass, "entity2Model method does not accept a null class");
        String tableName = null;
        Map<String, Object> entityMap = ModelUtilsOfEntity.getFirstEntityAnno(entityClass, "Entity");
        tableName = (String)entityMap.get("name");
        Map<String, Object> tableMap = ModelUtilsOfEntity.getFirstEntityAnno(entityClass, "Table");
        if (!StrUtils.isEmpty(tableMap.get("name"))) {
            tableName = (String)tableMap.get("name");
        }
        if (StrUtils.isEmpty(tableName)) {
            tableName = entityClass.getSimpleName();
        }
        TableModel model = new TableModel(tableName);
        if (!tableMap.isEmpty()) {
            Annotation[] uniques;
            Annotation[] indexes = (Annotation[])tableMap.get("indexes");
            if (indexes != null && indexes.length > 0) {
                for (Annotation anno : indexes) {
                    Map<String, Object> mp = ModelUtilsOfEntity.changeAnnotationValuesToMap(anno, anno.annotationType());
                    String columnListString = (String)mp.get("columnList");
                    String[] columns = columnListString.indexOf(44) >= 0 ? columnListString.split(",") : new String[]{columnListString};
                    if (columns.length <= 0) continue;
                    model.index((String)mp.get("name")).columns(columns).setUnique((Boolean)mp.get("unique"));
                }
            }
            if ((uniques = (Annotation[])tableMap.get("uniqueConstraints")) != null && uniques.length > 0) {
                for (Annotation anno : uniques) {
                    Map<String, Object> mp = ModelUtilsOfEntity.changeAnnotationValuesToMap(anno, anno.annotationType());
                    String[] columnNames = (String[])mp.get("columnNames");
                    if (columnNames == null || columnNames.length <= 0) continue;
                    model.unique((String)mp.get("name")).columns(columnNames);
                }
            }
        }
        if (!(seqMap = ModelUtilsOfEntity.getFirstEntityAnno(entityClass, "SequenceGenerator")).isEmpty()) {
            model.sequenceGenerator((String)seqMap.get("name"), (String)seqMap.get("sequenceName"), (Integer)seqMap.get("initialValue"), (Integer)seqMap.get("allocationSize"));
        }
        if (!(tableGenMap = ModelUtilsOfEntity.getFirstEntityAnno(entityClass, "TableGenerator")).isEmpty()) {
            model.tableGenerator((String)tableGenMap.get("name"), (String)tableGenMap.get("table"), (String)tableGenMap.get("pkColumnName"), (String)tableGenMap.get("valueColumnName"), (String)tableGenMap.get("pkColumnValue"), (Integer)tableGenMap.get("initialValue"), (Integer)tableGenMap.get("allocationSize"));
        }
        if (!(uuidAnyMp = ModelUtilsOfEntity.getFirstEntityAnno(entityClass, "UUIDAny")).isEmpty()) {
            model.uuidAny((String)uuidAnyMp.get("name"), (Integer)uuidAnyMp.get("length"));
        }
        List<Map<String, Object>> fkeys = ModelUtilsOfEntity.getEntityAnnos(entityClass, "FKey");
        for (Map<String, Object> map : fkeys) {
            Boolean ddl = (Boolean)map.get("ddl");
            if (ddl == null) {
                ddl = true;
            }
            model.fkey((String)map.get("name")).columns((String[])map.get("columns")).refs((String[])map.get("refs")).ddl(ddl);
        }
        BeanInfo beanInfo = null;
        PropertyDescriptor[] pds = null;
        try {
            beanInfo = Introspector.getBeanInfo(entityClass);
            pds = beanInfo.getPropertyDescriptors();
        }
        catch (Exception e) {
            DialectException.throwEX(e, "entity2Model can not get bean info");
        }
        for (PropertyDescriptor pd : pds) {
            Map<String, Object> uniMap;
            Map<String, Object> idxMap;
            Map<String, Object> refMap;
            Object strategy;
            Map<String, Object> gvMap;
            Field field;
            Class<?> propertyClass;
            String entityfieldName = pd.getName();
            if ("class".equals(entityfieldName) || "simpleName".equals(entityfieldName) || "canonicalName".equals(entityfieldName) || "box".equals(entityfieldName) || !TypeUtils.canMapToSqlType(propertyClass = pd.getPropertyType()) || (field = ReflectionUtils.findField(entityClass, entityfieldName)) == null) continue;
            if (!ModelUtilsOfEntity.getFirstEntityAnno(field, "Transient").isEmpty()) {
                ColumnModel col = new ColumnModel(entityfieldName);
                col.setColumnType(TypeUtils.toType(propertyClass));
                col.setLengths(new Integer[]{255, 0, 0});
                col.setTransientable(true);
                col.setTableModel(model);
                model.addColumn(col);
                continue;
            }
            Map<String, Object> map = ModelUtilsOfEntity.getFirstEntityAnno(field, "SequenceGenerator");
            if (!map.isEmpty()) {
                model.sequenceGenerator((String)map.get("name"), (String)map.get("sequenceName"), (Integer)map.get("initialValue"), (Integer)map.get("allocationSize"));
            }
            if (!(map = ModelUtilsOfEntity.getFirstEntityAnno(field, "TableGenerator")).isEmpty()) {
                model.tableGenerator((String)map.get("name"), (String)map.get("table"), (String)map.get("pkColumnName"), (String)map.get("valueColumnName"), (String)map.get("pkColumnValue"), (Integer)map.get("initialValue"), (Integer)map.get("allocationSize"));
            }
            if (!(map = ModelUtilsOfEntity.getFirstEntityAnno(field, "UUIDAny")).isEmpty()) {
                model.uuidAny((String)map.get("name"), (Integer)map.get("length"));
            }
            ColumnModel col = new ColumnModel(entityfieldName);
            col.entityField(entityfieldName);
            Map<String, Object> colMap = ModelUtilsOfEntity.getFirstEntityAnno(field, "Column");
            if (!colMap.isEmpty()) {
                if (!((Boolean)colMap.get("nullable")).booleanValue()) {
                    col.setNullable(false);
                }
                if (!StrUtils.isEmpty(colMap.get("name"))) {
                    col.setColumnName((String)colMap.get("name"));
                }
                col.setLength((Integer)colMap.get("length"));
                col.setPrecision((Integer)colMap.get("precision"));
                col.setScale((Integer)colMap.get("scale"));
                col.setLengths(new Integer[]{col.getLength(), col.getPrecision(), col.getScale()});
                if (!StrUtils.isEmpty(colMap.get("columnDefinition"))) {
                    col.setColumnType(TypeUtils.toType((String)colMap.get("columnDefinition")));
                } else {
                    col.setColumnType(TypeUtils.toType(propertyClass));
                }
                col.setInsertable((Boolean)colMap.get("insertable"));
                col.setUpdatable((Boolean)colMap.get("updatable"));
            } else {
                col.setColumnType(TypeUtils.toType(propertyClass));
                col.setLengths(new Integer[]{255, 0, 0});
            }
            if (!ModelUtilsOfEntity.getFirstEntityAnno(field, "Id").isEmpty() || !ModelUtilsOfEntity.getFirstEntityAnno(field, "PKey").isEmpty()) {
                col.pkey();
            }
            col.setEntityField(entityfieldName);
            col.setTableModel(model);
            model.addColumn(col);
            if (ModelUtilsOfEntity.existEntityAnno(field, "AutoId")) {
                col.autoId();
            }
            if (ModelUtilsOfEntity.existEntityAnno(field, "IdentityId")) {
                col.identityId();
            }
            if (ModelUtilsOfEntity.existEntityAnno(field, "TimeStampId")) {
                col.timeStampId();
            }
            if (ModelUtilsOfEntity.existEntityAnno(field, "UUID25")) {
                col.uuid25();
            }
            if (ModelUtilsOfEntity.existEntityAnno(field, "UUID32")) {
                col.uuid32();
            }
            if (ModelUtilsOfEntity.existEntityAnno(field, "UUID36")) {
                col.uuid36();
            }
            if (!(gvMap = ModelUtilsOfEntity.getFirstEntityAnno(field, "GeneratedValue")).isEmpty() && (strategy = gvMap.get("strategy")) != null) {
                String strategyStr = strategy.toString();
                if ("AUTO".equals(strategyStr)) {
                    col.autoId();
                } else if ("IDENTITY".equals(strategyStr)) {
                    col.identityId();
                } else if ("UUID25".equals(strategyStr)) {
                    col.uuid25();
                } else if ("UUID32".equals(strategyStr)) {
                    col.uuid32();
                } else if ("UUID36".equals(strategyStr)) {
                    col.uuid36();
                } else if ("TIMESTAMP".equals(strategyStr)) {
                    col.timeStampId();
                } else {
                    String generator = (String)gvMap.get("generator");
                    if (StrUtils.isEmpty(generator)) {
                        throw new DialectException("GeneratedValue strategy '" + strategyStr + "' can not find a generator");
                    }
                    col.idGenerator(generator);
                }
            }
            if (!(refMap = ModelUtilsOfEntity.getFirstEntityAnno(field, "SingleFKey")).isEmpty()) {
                Boolean ddl = (Boolean)refMap.get("ddl");
                if (ddl == null) {
                    ddl = true;
                }
                model.fkey((String)refMap.get("name")).columns(col.getColumnName()).refs((String[])refMap.get("refs")).ddl(ddl);
            }
            if (!(idxMap = ModelUtilsOfEntity.getFirstEntityAnno(field, "SingleIndex")).isEmpty()) {
                model.index((String)idxMap.get("name")).columns(col.getColumnName());
            }
            if ((uniMap = ModelUtilsOfEntity.getFirstEntityAnno(field, "SingleUnique")).isEmpty()) continue;
            model.unique((String)uniMap.get("name")).columns(col.getColumnName());
        }
        return model;
    }
}

