/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.util.Arrays;
import java.util.List;

public abstract class DebugUtils {
    public static String getColumnModelDebugInfo(ColumnModel c) {
        StringBuilder sb = new StringBuilder();
        sb.append("columnName=" + c.getColumnName()).append(", ");
        sb.append("type=" + (Object)((Object)c.getColumnType())).append(", ");
        sb.append("pkey=" + c.getPkey()).append(", ");
        sb.append("lengths=");
        if (c.getLengths() != null) {
            for (Integer length : c.getLengths()) {
                sb.append(length).append(", ");
            }
        }
        sb.append("getEntityField=" + c.getEntityField());
        return sb.toString();
    }

    public static String getFkeyDebugInfo(TableModel t) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fkeys:\r");
        for (FKeyModel k : t.getFkeyConstraints()) {
            sb.append("FkeyName=" + k.getFkeyName());
            sb.append(", ColumnNames=" + k.getColumnNames());
            sb.append(", RefTableAndColumns=" + Arrays.deepToString(k.getRefTableAndColumns()));
            sb.append("\r");
        }
        return sb.toString();
    }

    public static String getTableModelDebugInfo(TableModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("\rtableName=" + model.getTableName()).append("\r");
        sb.append("getEntityClass=" + model.getEntityClass()).append("\r");
        sb.append("getAlias=" + model.getAlias()).append("\r");
        sb.append(DebugUtils.getFkeyDebugInfo(model));
        List<ColumnModel> columns = model.getColumns();
        for (ColumnModel column : columns) {
            sb.append(DebugUtils.getColumnModelDebugInfo(column)).append("\r");
        }
        return sb.toString();
    }

    public static String getTableModelsDebugInfo(TableModel[] models) {
        StringBuilder sb = new StringBuilder();
        for (TableModel model : models) {
            sb.append(DebugUtils.getTableModelDebugInfo(model));
        }
        return sb.toString();
    }
}

