/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DialectException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class StrUtils {
    private static final SecureRandom random = new SecureRandom();
    private static final char[] ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();

    private StrUtils() {
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StrUtils.hasLength((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!StrUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StrUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StrUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int length = searchStr.length();
        if (length == 0) {
            return true;
        }
        for (int i = str.length() - length; i >= 0; --i) {
            if (!str.regionMatches(true, i, searchStr, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String replace(String originString, String oldPattern, String newPattern) {
        if (!StrUtils.hasLength(originString) || !StrUtils.hasLength(oldPattern) || newPattern == null) {
            return originString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = originString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(originString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = originString.indexOf(oldPattern, pos);
        }
        sb.append(originString.substring(pos));
        return sb.toString();
    }

    public static String replaceFirst(String originString, String oldPattern, String newPattern) {
        if (!StrUtils.hasLength(originString) || !StrUtils.hasLength(oldPattern) || newPattern == null) {
            return originString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = originString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        if (index >= 0) {
            sb.append(originString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = originString.indexOf(oldPattern, pos);
        }
        sb.append(originString.substring(pos));
        return sb.toString();
    }

    public static String replaceIgnoreCase(String text, String findtxt, String replacetxt) {
        if (text == null) {
            return null;
        }
        String str = text;
        if (findtxt == null || findtxt.length() == 0) {
            return str;
        }
        if (findtxt.length() > str.length()) {
            return str;
        }
        int counter = 0;
        while (counter < str.length() && str.substring(counter).length() >= findtxt.length()) {
            String thesubstr = str.substring(counter, counter + findtxt.length());
            if (thesubstr.equalsIgnoreCase(findtxt)) {
                str = str.substring(0, counter) + replacetxt + str.substring(counter + findtxt.length());
                counter += replacetxt.length();
                continue;
            }
            ++counter;
        }
        return str;
    }

    public static int indexOfIgnoreCase(String str, String searchStr) {
        if (searchStr.isEmpty() || str.isEmpty()) {
            return str.indexOf(searchStr);
        }
        for (int i = 0; i < str.length(); ++i) {
            char c2;
            char c;
            if (i + searchStr.length() > str.length()) {
                return -1;
            }
            int j = 0;
            for (int ii = i; ii < str.length() && j < searchStr.length() && (c = Character.toLowerCase(str.charAt(ii))) == (c2 = Character.toLowerCase(searchStr.charAt(j))); ++j, ++ii) {
            }
            if (j != searchStr.length()) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(String str, String searchStr) {
        if (searchStr.isEmpty() || str.isEmpty()) {
            return -1;
        }
        return str.toLowerCase().lastIndexOf(searchStr.toLowerCase());
    }

    public static String[] split(String str, char separatorChar) {
        return StrUtils.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return new String[0];
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] substringsBetween(String str, String open, String close) {
        int end;
        int start;
        if (str == null || StrUtils.isEmpty(open) || StrUtils.isEmpty(close)) {
            return new String[0];
        }
        int strLen = str.length();
        if (strLen == 0) {
            return new String[0];
        }
        int closeLen = close.length();
        int openLen = open.length();
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (pos < strLen - closeLen && (start = str.indexOf(open, pos)) >= 0 && (end = str.indexOf(close, start += openLen)) >= 0) {
            list.add(str.substring(start, end));
            pos = end + closeLen;
        }
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.toArray(new String[list.size()]);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringBefore(String str, String separator) {
        if (StrUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringAfter(String str, String separator) {
        if (StrUtils.isEmpty(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String substringAfterLast(String str, String separator) {
        if (StrUtils.isEmpty(str)) {
            return str;
        }
        if (StrUtils.isEmpty(separator)) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String substringBeforeLast(String str, String separator) {
        if (StrUtils.isEmpty(str) || StrUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static int countMatches(CharSequence str, char ch) {
        if (StrUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String getRandomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHABET[random.nextInt(32)]);
        }
        return sb.toString();
    }

    public static boolean arraysEqual(Object[] array1, Object[] array2) {
        if (array1 == null || array1.length == 0 || array2 == null || array2.length == 0) {
            DialectException.throwEX("StrUtils arraysEqual() method can not compare empty arrays");
        }
        for (int i = 0; array1 != null && array2 != null && i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static String arrayToStringButSkipFirst(Object[] array) {
        if (array == null) {
            DialectException.throwEX("StrUtils arrayToString() method do not accept null parameter");
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Object object : array) {
            if (i++ == 1) continue;
            sb.append("" + object + ",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String arrayToString(Object[] array) {
        if (array == null) {
            DialectException.throwEX("StrUtils arrayToString() method do not accept null parameter");
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : array) {
            sb.append("" + object + ",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String arrayToString(Object[] array, String seperateString) {
        if (array == null) {
            DialectException.throwEX("StrUtils arrayToString() method do not accept null parameter");
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : array) {
            sb.append("" + object + seperateString);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - seperateString.length());
        }
        return sb.toString();
    }

    public static String listToString(List<?> lst) {
        if (lst == null) {
            DialectException.throwEX("StrUtils listToString() method do not accept null parameter");
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : lst) {
            sb.append("" + object + ",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String[] joinStringArray(String[] array1, String[] array2) {
        ArrayList<String> l = new ArrayList<String>();
        for (String string : array1) {
            l.add(string);
        }
        for (String string : array2) {
            l.add(string);
        }
        return l.toArray(new String[l.size()]);
    }

    public static boolean isCapitalizedString(String str) {
        char c = str.substring(0, 1).toCharArray()[0];
        return c >= 'A' && c <= 'Z';
    }
}

